/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.FluidColorHelper;
import teamroots.embers.util.Misc;

public class TileEntityTank
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable {
    public static int capacity = ConfigMachine.TANK.capacity;

    public TileEntityTank() {
        this.tank = new FluidTank(capacity){

            public void onContentsChanged() {
                TileEntityTank.this.func_70296_d();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityTank.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return super.fill(resource, doFill);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.shouldEmitParticles()) {
            this.updateEscapeParticles();
        }
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(FluidColorHelper.getColor(this.lastEscaped), true);
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            float yOffset = 0.9f;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            ParticleUtil.spawnParticleVapor(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + xOffset, (float)this.field_174879_c.func_177956_o() + yOffset, (float)this.field_174879_c.func_177952_p() + zOffset, 0.0f, 0.05f, 0.0f, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 4.0f, 2.0f, 20);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            this.func_70296_d();
            return didFill;
        }
        return false;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        if (!(world.field_72995_K || player != null && player.field_71075_bZ.field_75098_d)) {
            ItemStack toDrop = new ItemStack(BlockRegister.BLOCK_TANK, 1);
            if (this.getTank().getFluidAmount() > 0) {
                NBTTagCompound tag = new NBTTagCompound();
                this.getTank().writeToNBT(tag);
                toDrop.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, toDrop));
        }
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }
}

