/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberPulser;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityPulser
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public static final double PULL_RATE = ConfigMachine.EJECTOR.pull_rate;
    public static final double TRANSFER_RATE = ConfigMachine.EJECTOR.transfer_rate;
    public static final double EMBER_CAPACITY = ConfigMachine.EJECTOR.capacity;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityPulser.this.func_70296_d();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityPulser() {
        this.capability.setEmberCapacity(EMBER_CAPACITY);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityPulser.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityPulser.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityPulser.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityPulser.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityPulser.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityPulser.connectionFromInt(tag.func_74762_e("east"));
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Misc.isValidLever(world, pos, side) ? EnumConnection.LEVER : EnumConnection.NONE;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        TileEntity targetTile;
        IEmberCapability cap;
        ++this.ticksExisted;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEmberPulser.facing);
        TileEntity attachedTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (this.ticksExisted % 5L == 0L && attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(PULL_RATE, true);
            this.capability.addAmount(removed, true);
        }
        if ((this.ticksExisted + (long)this.offset) % 20L == 0L && this.func_145831_w().func_175640_z(this.func_174877_v()) && this.target != null && !this.func_145831_w().field_72995_K && this.capability.getEmber() > PULL_RATE && (targetTile = this.func_145831_w().func_175625_s(this.target)) instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)targetTile).isFull()) {
            EntityEmberPacket packet = new EntityEmberPacket(this.func_145831_w());
            Vec3d velocity = this.getBurstVelocity(facing);
            packet.initCustom(this.func_174877_v(), this.target, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, Math.min(TRANSFER_RATE, this.capability.getEmber()));
            this.capability.removeAmount(Math.min(TRANSFER_RATE, this.capability.getEmber()), true);
            this.func_145831_w().func_72838_d((Entity)packet);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundManager.EMBER_EMIT_BIG, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private Vec3d getBurstVelocity(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3d(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3d(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3d(0.5, -0.01, 0.0);
            }
        }
        return Vec3d.field_186680_a;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        this.target = pos;
        this.func_70296_d();
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

