/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.SoundManager;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.tile.IOrderDestination;
import teamroots.embers.api.tile.IOrderSource;
import teamroots.embers.api.tile.OrderStack;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.TileEntityItemPipe;
import teamroots.embers.tileentity.TileEntityItemPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityItemExtractor
extends TileEntityItemPipeBase
implements IOrderDestination {
    Random random = new Random();
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.field_82609_l.length];
    IItemHandler[] sideHandlers;
    boolean syncConnections;
    boolean active;
    List<OrderStack> orders = new ArrayList<OrderStack>();

    @Override
    protected void initInventory() {
        super.initInventory();
        this.sideHandlers = new IItemHandler[EnumFacing.field_82609_l.length];
        for (final EnumFacing facing : EnumFacing.field_82609_l) {
            this.sideHandlers[facing.func_176745_a()] = new IItemHandler(){

                public int getSlots() {
                    return TileEntityItemExtractor.this.inventory.getSlots();
                }

                @Nonnull
                public ItemStack getStackInSlot(int slot) {
                    return TileEntityItemExtractor.this.inventory.getStackInSlot(slot);
                }

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (TileEntityItemExtractor.this.active) {
                        return stack;
                    }
                    if (!simulate) {
                        TileEntityItemExtractor.this.setFrom(facing, true);
                    }
                    return TileEntityItemExtractor.this.inventory.insertItem(slot, stack, simulate);
                }

                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return TileEntityItemExtractor.this.inventory.extractItem(slot, amount, simulate);
                }

                public int getSlotLimit(int slot) {
                    return TileEntityItemExtractor.this.inventory.getSlotLimit(slot);
                }
            };
        }
    }

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setInternalConnection(facing, this.getConnection(world, this.func_174877_v().func_177972_a(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeConnections(tag);
        NBTTagList tagOrders = new NBTTagList();
        for (OrderStack order : this.orders) {
            tagOrders.func_74742_a((NBTBase)order.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("orders", (NBTBase)tagOrders);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.func_74768_a("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.func_74768_a("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.func_74768_a("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.func_74768_a("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.func_74768_a("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.func_74768_a("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.func_74762_e("up")));
        }
        if (tag.func_74764_b("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.func_74762_e("down")));
        }
        if (tag.func_74764_b("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.func_74762_e("north")));
        }
        if (tag.func_74764_b("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.func_74762_e("south")));
        }
        if (tag.func_74764_b("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.func_74762_e("west")));
        }
        if (tag.func_74764_b("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.func_74762_e("east")));
        }
        if (tag.func_74764_b("orders")) {
            NBTTagList tagOrders = tag.func_150295_c("orders", 10);
            this.orders.clear();
            for (NBTBase tagOrder : tagOrders) {
                this.orders.add(new OrderStack((NBTTagCompound)tagOrder));
            }
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    @Override
    int getCapacity() {
        return 4;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.inventory;
            }
            return (T)this.sideHandlers[facing.func_176745_a()];
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.func_176745_a()] != null ? this.connections[facing.func_176745_a()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.func_176745_a()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof TileEntityItemExtractor) {
            return EnumPipeConnection.NONE;
        }
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(side.func_176734_d());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityItemExtractor.reverseForce(connection));
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (tile instanceof TileEntityItemPipe) {
            ((TileEntityItemPipe)tile).updateNeighbors((IBlockAccess)this.field_145850_b);
        }
        if (tile instanceof TileEntityItemExtractor) {
            ((TileEntityItemExtractor)tile).updateNeighbors((IBlockAccess)this.field_145850_b);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    @Override
    public void order(TileEntity source, IFilter filter, int orderSize) {
        OrderStack order = this.getOrder(source);
        if (order == null) {
            this.orders.add(new OrderStack(source.func_174877_v(), filter, orderSize));
        } else if (Objects.equals(order.getFilter(), filter)) {
            order.increment(orderSize);
        } else {
            order.reset(filter, orderSize);
        }
    }

    @Override
    public void resetOrder(TileEntity source) {
        this.orders.removeIf(order -> order.getPos().equals((Object)source.func_174877_v()));
    }

    public OrderStack getOrder(TileEntity source) {
        for (OrderStack order : this.orders) {
            if (!order.getPos().equals((Object)source.func_174877_v())) continue;
            return order;
        }
        return null;
    }

    private void cleanupOrders() {
        this.orders.removeIf(this::isOrderInvalid);
    }

    private boolean isOrderInvalid(OrderStack order) {
        return order.getSize() <= 0 || order.getSource(this.field_145850_b) == null;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.clogged) {
            Misc.spawnClogParticles(this.field_145850_b, this.field_174879_c, 1, 0.25f);
        }
        if (!this.field_145850_b.field_72995_K) {
            IOrderSource destination;
            this.cleanupOrders();
            this.active = this.func_145831_w().func_175640_z(this.func_174877_v());
            OrderStack currentOrder = this.orders.isEmpty() ? null : this.orders.get(0);
            IFilter filter = FilterUtil.FILTER_ANY;
            if (this.active) {
                currentOrder = null;
            } else if (currentOrder != null) {
                filter = currentOrder.getFilter();
            }
            IItemHandler invDest = null;
            if (currentOrder != null && (destination = currentOrder.getSource(this.field_145850_b)) != null) {
                invDest = destination.getItemHandler();
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile;
                if (!this.isConnected(facing) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || tile instanceof TileEntityItemPipeBase || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
                if (this.active || currentOrder != null && currentOrder.getSize() > 0) {
                    ItemStack extracted;
                    IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    int slot = -1;
                    for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                        ItemStack extracted2 = handler.extractItem(j, 1, true);
                        if (extracted2.func_190926_b() || !filter.acceptsItem(extracted2, invDest)) continue;
                        slot = j;
                    }
                    if (slot != -1 && this.inventory.insertItem(0, extracted = handler.extractItem(slot, 1, true), true).func_190926_b()) {
                        handler.extractItem(slot, 1, false);
                        this.inventory.insertItem(0, extracted, false);
                        if (currentOrder != null) {
                            currentOrder.deplete(extracted.func_190916_E());
                        }
                    }
                    this.setFrom(facing, true);
                    continue;
                }
                this.setFrom(facing, false);
            }
        }
        super.func_73660_a();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

