/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.tileentity.TileEntityGeoSeparator;

public class TileEntityGeoSeparatorRenderer
extends TileEntitySpecialRenderer<TileEntityGeoSeparator> {
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityGeoSeparator tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            FluidStack fluidStack = tile.getFluidStack();
            int capacity = tile.getCapacity();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                this.blue = c & 0xFF;
                this.green = c >> 8 & 0xFF;
                this.red = c >> 16 & 0xFF;
                this.alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.func_94209_e() + this.diffU * 0.25;
                this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.25;
                this.minV = (double)sprite.func_94206_g() + this.diffV * 0.25;
                this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.25;
                int i = this.func_178459_a().func_175626_b(tile.func_174877_v(), fluid.getLuminosity(fluidStack));
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                buffer.func_181662_b(x + 0.25, y + 0.25 + 0.1875 * (double)((float)amount / (float)amount), z + 0.25).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.25 + 0.1875 * (double)((float)amount / (float)amount), z + 0.25).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.25 + 0.1875 * (double)((float)amount / (float)amount), z + 0.75).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.25 + 0.1875 * (double)((float)amount / (float)amount), z + 0.75).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
            }
        }
    }
}

