/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.SoundManager;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.TileEntityFluidExtractor;
import teamroots.embers.tileentity.TileEntityFluidPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.ItemUtil;
import teamroots.embers.util.Misc;

public class TileEntityFluidPipe
extends TileEntityFluidPipeBase {
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.field_82609_l.length];
    IFluidHandler[] sideHandlers;
    boolean syncConnections;

    @Override
    protected void initFluidTank() {
        super.initFluidTank();
        this.sideHandlers = new IFluidHandler[EnumFacing.field_82609_l.length];
        for (final EnumFacing facing : EnumFacing.field_82609_l) {
            this.sideHandlers[facing.func_176745_a()] = new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return TileEntityFluidPipe.this.tank.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (doFill) {
                        TileEntityFluidPipe.this.setFrom(facing, true);
                    }
                    return TileEntityFluidPipe.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileEntityFluidPipe.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileEntityFluidPipe.this.tank.drain(maxDrain, doDrain);
                }
            };
        }
    }

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setInternalConnection(facing, this.getConnection(world, this.func_174877_v().func_177972_a(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.clogged && this.isAnySideUnclogged()) {
            Misc.spawnClogParticles(this.field_145850_b, this.field_174879_c, 1, 0.25f);
        }
        super.func_73660_a();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeConnections(tag);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.func_74768_a("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.func_74768_a("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.func_74768_a("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.func_74768_a("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.func_74768_a("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.func_74768_a("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.func_74762_e("up")));
        }
        if (tag.func_74764_b("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.func_74762_e("down")));
        }
        if (tag.func_74764_b("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.func_74762_e("north")));
        }
        if (tag.func_74764_b("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.func_74762_e("south")));
        }
        if (tag.func_74764_b("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.func_74762_e("west")));
        }
        if (tag.func_74764_b("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.func_74762_e("east")));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.getInternalConnection(facing).canTransfer())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.tank;
            }
            if (this.getInternalConnection(facing).canTransfer()) {
                return (T)this.sideHandlers[facing.func_176745_a()];
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    int getCapacity() {
        return 250;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.func_176745_a()] != null ? this.connections[facing.func_176745_a()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.func_176745_a()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof IFluidPipeConnectable) {
            return ((IFluidPipeConnectable)tile).getConnection(side.func_176734_d());
        }
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidPipeConnector(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityFluidPipe.reverseForce(connection));
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (tile instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)tile).updateNeighbors((IBlockAccess)this.field_145850_b);
        }
        if (tile instanceof TileEntityFluidExtractor) {
            ((TileEntityFluidExtractor)tile).updateNeighbors((IBlockAccess)this.field_145850_b);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        if (this.clogged && !heldItem.func_190926_b() && ItemUtil.matchesOreDict(heldItem, "stickWood")) {
            if (this.tank.getFluidAmount() > 0 && !world.field_72995_K) {
                this.tank.setFluid(null);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

