/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.research;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.config.ConfigMisc;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.util.Vec2i;

public class ResearchCategory {
    public static final ArrayList<ResearchBase> NO_PREREQUISITES = Lists.newArrayList();
    public String name = "";
    public double u = 192.0;
    public double v = 0.0;
    public ResourceLocation texture = new ResourceLocation("embers", "textures/gui/codex_index.png");
    public ResourceLocation background = new ResourceLocation("embers", "textures/gui/codex_category.png");
    public ArrayList<ResearchBase> researches = new ArrayList();
    public ArrayList<ResearchBase> prerequisites = new ArrayList();
    public LinkedList<Vec2i> goodLocations = new LinkedList();

    public ResearchCategory(String name, double v) {
        this.name = name;
        this.v = v;
    }

    public ResearchCategory(String name, ResourceLocation loc, double u, double v) {
        this.name = name;
        this.v = v;
        this.u = u;
        this.texture = loc;
    }

    public ResearchCategory addResearch(ResearchBase base) {
        this.researches.add(base);
        return this;
    }

    public ResearchCategory pushGoodLocations(Vec2i ... locations) {
        Collections.addAll(this.goodLocations, locations);
        return this;
    }

    public Vec2i popGoodLocation() {
        if (this.goodLocations.isEmpty()) {
            return null;
        }
        return this.goodLocations.removeFirst();
    }

    public void findByTag(String match, Map<ResearchBase, Integer> result, Set<ResearchCategory> categories) {
        if (categories.contains(this)) {
            return;
        }
        categories.add(this);
        for (ResearchBase research : this.researches) {
            research.findByTag(match, result, categories);
        }
    }

    public void addPrerequisite(ResearchBase base) {
        this.prerequisites.add(base);
    }

    public List<ResearchBase> getPrerequisites() {
        if (ConfigMisc.codexCategoryIsProgress) {
            return this.prerequisites;
        }
        return NO_PREREQUISITES;
    }

    public boolean isChecked() {
        return this.getPrerequisites().stream().allMatch(ResearchBase::isChecked);
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)("embers.research." + this.name), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(boolean showTooltips) {
        ArrayList<String> tooltip = new ArrayList<String>();
        boolean isChecked = this.isChecked();
        if (showTooltips || !isChecked) {
            for (ResearchBase prerequisite : this.getPrerequisites()) {
                if (prerequisite.isChecked()) {
                    tooltip.add(I18n.func_135052_a((String)"embers.research.prerequisite.unlocked", (Object[])new Object[]{prerequisite.getName()}));
                    continue;
                }
                tooltip.add(I18n.func_135052_a((String)"embers.research.prerequisite.locked", (Object[])new Object[]{prerequisite.getName()}));
            }
        }
        return tooltip;
    }

    public double getIconU() {
        return this.u;
    }

    public double getIconV() {
        return this.v;
    }

    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public ResourceLocation getIndexTexture() {
        return this.texture;
    }

    public void getAllResearch(Set<ResearchBase> result) {
        for (ResearchBase research : this.researches) {
            research.getAllResearch(result);
        }
    }
}

