/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.particle.ParticleGlow;

public class ParticleRenderer {
    private final ArrayDeque<Particle> normalParticles = new ArrayDeque();
    private final ArrayDeque<Particle> additiveParticles = new ArrayDeque();
    private final ArrayDeque<Particle> throughParticles = new ArrayDeque();
    private final ArrayDeque<Particle> additiveThroughParticles = new ArrayDeque();
    private final Queue<Particle> queue = new ArrayDeque<Particle>();

    public void updateParticles() {
        this.updateParticles(this.normalParticles);
        this.updateParticles(this.additiveParticles);
        this.updateParticles(this.throughParticles);
        this.updateParticles(this.additiveThroughParticles);
        if (!this.queue.isEmpty()) {
            Particle particle = this.queue.poll();
            while (particle != null) {
                IEmberParticle emberParticle = (IEmberParticle)particle;
                boolean additive = emberParticle.isAdditive();
                boolean rendersThrough = emberParticle.renderThroughBlocks();
                this.getParticleCollection(additive, rendersThrough).add(particle);
                particle = this.queue.poll();
            }
        }
    }

    public void updateParticles(ArrayDeque<Particle> particles) {
        Iterator<Particle> iterator = particles.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            if (((IEmberParticle)particle).alive() && (ConfigClient.enableParticles || particle instanceof ParticleGlow)) {
                particle.func_189213_a();
                continue;
            }
            iterator.remove();
        }
    }

    public void renderParticles(EntityPlayer dumbplayer, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            Particle.field_190016_K = player.func_70676_i(partialTicks);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.normalParticles) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.additiveParticles) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.func_179097_i();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.throughParticles) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.additiveThroughParticles) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    public void addParticle(Particle particle) {
        if (!ConfigClient.enableParticles && !(particle instanceof ParticleGlow)) {
            return;
        }
        if (particle instanceof IEmberParticle) {
            this.queue.add(particle);
        }
    }

    private Collection<Particle> getParticleCollection(boolean additive, boolean rendersThroughBlocks) {
        if (!rendersThroughBlocks && !additive) {
            return this.normalParticles;
        }
        if (!rendersThroughBlocks) {
            return this.additiveParticles;
        }
        if (!additive) {
            return this.throughParticles;
        }
        return this.additiveThroughParticles;
    }
}

