/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import teamroots.embers.util.EmberGenUtil;

public class EmberWorldData
extends WorldSavedData {
    public EmberWorldData(String name) {
        super(name);
    }

    public EmberWorldData() {
        super("embers");
    }

    public void readFromNBT(NBTTagCompound tag) {
        EmberGenUtil.offX = tag.getInteger("offX");
        EmberGenUtil.offZ = tag.getInteger("offZ");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setInteger("offX", EmberGenUtil.offX);
        tag.setInteger("offZ", EmberGenUtil.offZ);
        return tag;
    }

    public static EmberWorldData get(World world) {
        EmberWorldData data = null;
        if (world != null && (EmberWorldData)world.loadData(EmberWorldData.class, "embers") != null) {
            data = (EmberWorldData)world.loadData(EmberWorldData.class, "embers");
        }
        if (data == null && world != null) {
            data = new EmberWorldData();
        }
        return data;
    }
}

