/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util.sound;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import teamroots.embers.util.sound.ISoundController;

public class MachineSound
extends PositionedSound
implements ITickableSound {
    protected TileEntity boundTile;
    protected boolean donePlaying;
    protected int id;

    public MachineSound(TileEntity tile, int id, SoundEvent soundIn, SoundCategory categoryIn, boolean repeatIn, float volumeIn, float pitchIn, float xIn, float yIn, float zIn) {
        super(soundIn, categoryIn);
        this.boundTile = tile;
        this.id = id;
        this.volume = volumeIn;
        this.pitch = pitchIn;
        this.xPosF = xIn;
        this.yPosF = yIn;
        this.zPosF = zIn;
        this.repeat = repeatIn;
        this.attenuationType = ISound.AttenuationType.LINEAR;
    }

    public boolean isDonePlaying() {
        return this.donePlaying;
    }

    public void update() {
        if (this.boundTile == null || this.boundTile.isInvalid()) {
            this.donePlaying = true;
        } else if (this.boundTile instanceof ISoundController) {
            ISoundController controller = (ISoundController)this.boundTile;
            if (!controller.shouldPlaySound(this.id)) {
                this.donePlaying = true;
            }
            this.volume = controller.getCurrentVolume(this.id, this.volume);
            this.pitch = controller.getCurrentPitch(this.id, this.pitch);
            if (this.donePlaying && controller.isSoundPlaying(this.id)) {
                controller.stopSound(this.id);
            }
        }
    }
}

