/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Quaternion;
import teamroots.embers.util.Misc;

public class TurretHelper {
    Quaternion angleStart = new Quaternion(0.0f, 1.0f, 0.0f, 0.0f);
    Quaternion angleEnd = new Quaternion(0.0f, 1.0f, 0.0f, 0.0f);
    float slide;
    float slideLast;
    Vec3d front;
    Vec3d up;

    public TurretHelper(Vec3d front, Vec3d up) {
        this.front = front;
        this.up = up;
    }

    public Quaternion getCurrentAngle() {
        return Misc.slerp(this.angleStart, this.angleEnd, this.slide);
    }

    public Quaternion getCurrentAngle(float partialTicks) {
        return Misc.slerp(this.angleStart, this.angleEnd, (float)MathHelper.clampedLerp((double)this.slideLast, (double)this.slide, (double)partialTicks));
    }

    public static Vec3d getForward(Quaternion angle) {
        float x = 2.0f * (angle.x * angle.z + angle.w * angle.y);
        float y = 2.0f * (angle.y * angle.z - angle.w * angle.x);
        float z = 1.0f - 2.0f * (angle.x * angle.x + angle.y * angle.y);
        return new Vec3d((double)x, (double)y, (double)z).normalize();
    }

    public static Vec3d getUp(Quaternion angle) {
        float x = 2.0f * (angle.x * angle.y - angle.w * angle.z);
        float y = 1.0f - 2.0f * (angle.x * angle.x + angle.z * angle.z);
        float z = 2.0f * (angle.y * angle.z + angle.w * angle.x);
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public static Vec3d getSide(Quaternion angle) {
        float x = 1.0f - 2.0f * (angle.y * angle.y + angle.z * angle.z);
        float y = 2.0f * (angle.x * angle.y + angle.w * angle.z);
        float z = 2.0f * (angle.x * angle.z - angle.w * angle.y);
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public void rotateTowards(Quaternion angle) {
        this.angleStart = this.getCurrentAngle();
        this.angleEnd = angle;
        this.slide = 0.0f;
    }

    public void rotateTowards(Vec3d forward) {
        Vec3d rotAxis = this.front.crossProduct(forward = forward.normalize()).normalize();
        if (rotAxis.lengthSquared() == 0.0) {
            rotAxis = this.up;
        }
        double dot = this.front.dotProduct(forward);
        double ang = Math.acos(dot);
        double s = Math.sin(ang / 2.0);
        Vec3d u = rotAxis.normalize();
        this.rotateTowards(new Quaternion((float)(u.x * s), (float)(u.y * s), (float)(u.z * s), (float)Math.cos(ang / 2.0)));
    }

    public void update(float speed) {
        this.slideLast = this.slide;
        this.slide = Math.min(this.slide + speed, 1.0f);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setTag("angleStart", (NBTBase)TurretHelper.writeQuat(this.angleStart));
        compound.setTag("angleEnd", (NBTBase)TurretHelper.writeQuat(this.angleEnd));
        compound.setFloat("slide", this.slide);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.angleStart = TurretHelper.readQuat(compound.getCompoundTag("angleStart"));
        this.angleEnd = TurretHelper.readQuat(compound.getCompoundTag("angleEnd"));
        this.slide = compound.getFloat("slide");
    }

    public static NBTTagCompound writeQuat(Quaternion quaternion) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setFloat("x", quaternion.x);
        compound.setFloat("y", quaternion.y);
        compound.setFloat("z", quaternion.z);
        compound.setFloat("w", quaternion.w);
        return compound;
    }

    public static Quaternion readQuat(NBTTagCompound compound) {
        return new Quaternion(compound.getFloat("x"), compound.getFloat("y"), compound.getFloat("z"), compound.getFloat("w"));
    }
}

