/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MatchUtil {
    public static StateComparator stateComparator = new StateComparator();
    public static StackComparator stackComparator = new StackComparator();
    public static NameComparator nameComparator = new NameComparator();

    public static String getOreKeys(ItemStack stack) {
        int[] keys = OreDictionary.getOreIDs((ItemStack)stack);
        String r = "";
        for (int i = 0; i < keys.length; ++i) {
            r = r + OreDictionary.getOreName((int)keys[i]);
        }
        return r;
    }

    public static boolean areStacksEqualOreDict(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() && stack2.isEmpty()) {
            return true;
        }
        if (stack1.isEmpty() && !stack2.isEmpty() || stack2.isEmpty() && !stack1.isEmpty()) {
            return false;
        }
        int[] ores1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] ores2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < ores1.length; ++i) {
            for (int j = 0; j < ores2.length; ++j) {
                if (ores1[i] != ores2[j]) continue;
                return true;
            }
        }
        return ItemStack.areItemStacksEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean stateListsMatch(List<IBlockState> list1, List<IBlockState> list2) {
        boolean doMatch;
        list1.sort(stateComparator);
        list2.sort(stateComparator);
        boolean bl = doMatch = list1.size() == list2.size();
        if (doMatch) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i).getBlock() == list2.get(i).getBlock() && list1.get(i).getBlock().getMetaFromState(list1.get(i)) == list2.get(i).getBlock().getMetaFromState(list2.get(i))) continue;
                doMatch = false;
            }
        }
        return doMatch;
    }

    public static boolean stackListsMatch(List<ItemStack> list1, List<ItemStack> list2) {
        ArrayList<ItemStack> list1backup = new ArrayList<ItemStack>();
        ArrayList<ItemStack> list2backup = new ArrayList<ItemStack>();
        if (list1.size() == list2.size()) {
            for (int i = 0; i < list1.size(); ++i) {
                boolean doContinue = true;
                for (int j = 0; j < list2.size() && doContinue; ++j) {
                    if (!MatchUtil.areStacksEqualOreDict(list1.get(i), list2.get(j))) continue;
                    list1backup.add(list1.get(i).copy());
                    list2backup.add(list2.get(j).copy());
                    list1.remove(i);
                    list2.remove(j);
                    i = -1;
                    j = -1;
                    doContinue = false;
                }
            }
            boolean doMatch = false;
            if (list1.size() == 0 && list2.size() == 0) {
                doMatch = true;
            }
            for (ItemStack i : list1backup) {
                list1.add(i);
            }
            for (ItemStack i : list2backup) {
                list2.add(i);
            }
            return doMatch;
        }
        return false;
    }

    public static class NameComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            return arg0.compareTo(arg1);
        }
    }

    public static class StackComparator
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack arg0, ItemStack arg1) {
            return (MatchUtil.getOreKeys(arg0) + "_" + arg0.getItem().getRegistryName().toString() + "_" + arg0.getItemDamage()).compareTo(MatchUtil.getOreKeys(arg0) + "_" + arg1.getItem().getRegistryName().toString() + "_" + arg1.getItemDamage());
        }
    }

    public static class StateComparator
    implements Comparator<IBlockState> {
        @Override
        public int compare(IBlockState arg0, IBlockState arg1) {
            return (arg0.getBlock().getRegistryName().toString() + "_" + arg0.getBlock().getMetaFromState(arg0)).compareTo(arg1.getBlock().getRegistryName().toString() + "_" + arg1.getBlock().getMetaFromState(arg1));
        }
    }
}

