/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.itemmod.ModifierCore;

@Deprecated
public class ItemModUtil {
    public static final String HEAT_TAG = "embers:heat_tag";
    public static Map<Item, ModifierBase> modifierRegistry = new HashMap<Item, ModifierBase>();
    public static Map<String, ModifierBase> nameToModifier = new HashMap<String, ModifierBase>();
    public static ArrayList<ModifierBase> weaponModifiers = new ArrayList();
    public static ArrayList<ModifierBase> armorModifiers = new ArrayList();
    public static ArrayList<ModifierBase> otherModifiers = new ArrayList();

    @Deprecated
    public static void init() {
    }

    public static void registerModifier(Item item, ModifierBase modifier) {
        modifierRegistry.put(item, modifier);
        nameToModifier.put(modifier.name, modifier);
        if (!(modifier instanceof ModifierCore)) {
            switch (modifier.type) {
                case ALL: 
                case PROJECTILE: {
                    otherModifiers.add(modifier);
                    break;
                }
                case TOOL_OR_ARMOR: {
                    weaponModifiers.add(modifier);
                    armorModifiers.add(modifier);
                    break;
                }
                case TOOL: {
                    weaponModifiers.add(modifier);
                    break;
                }
                case ARMOR: 
                case HELMET: 
                case CHESTPLATE: 
                case LEGGINGS: 
                case BOOTS: {
                    armorModifiers.add(modifier);
                }
            }
        }
    }

    public static boolean canAnyModifierApply(ItemStack stack) {
        Item item = stack.getItem();
        ArrayList<ModifierBase> testList = otherModifiers;
        if (item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe) {
            testList = weaponModifiers;
        } else if (item instanceof ItemArmor) {
            testList = armorModifiers;
        }
        for (ModifierBase modifier : testList) {
            if (!modifier.canApplyTo(stack)) continue;
            return true;
        }
        return false;
    }

    public static void checkForTag(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (!stack.getTagCompound().hasKey(HEAT_TAG)) {
            stack.getTagCompound().setTag(HEAT_TAG, (NBTBase)new NBTTagCompound());
            stack.getTagCompound().getCompoundTag(HEAT_TAG).setInteger("heat_level", 0);
            stack.getTagCompound().getCompoundTag(HEAT_TAG).setFloat("heat", 0.0f);
            stack.getTagCompound().getCompoundTag(HEAT_TAG).setTag("modifiers", (NBTBase)new NBTTagList());
        }
    }

    public static boolean isModValid(ItemStack stack, ItemStack mod) {
        ModifierBase b = modifierRegistry.get(mod.getItem());
        return b.canApplyTo(stack);
    }

    public static boolean hasModifier(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (!compound.hasKey("name") || compound.getString("name").compareTo(name) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addModifier(ItemStack stack, ItemStack mod) {
        ItemModUtil.checkForTag(stack);
        NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
        ModifierBase modifier = modifierRegistry.get(mod.getItem());
        if (ItemModUtil.getModifierLevel(stack, modifier.name) == 0) {
            NBTTagCompound modifierCompound = new NBTTagCompound();
            modifierCompound.setString("name", modifier.name);
            modifierCompound.setTag("item", (NBTBase)mod.writeToNBT(new NBTTagCompound()));
            modifierCompound.setInteger("level", 1);
            list.appendTag((NBTBase)modifierCompound);
        } else {
            ItemModUtil.incModifierLevel(stack, modifier.name);
        }
        modifier.onApply(stack);
    }

    public static int incModifierLevel(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (!compound.hasKey("name") || compound.getString("name").compareTo(name) != 0) continue;
                compound.setInteger("level", compound.getInteger("level") + 1);
            }
        }
        return 0;
    }

    public static int getTotalModLevel(ItemStack stack) {
        int total = 0;
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                ItemStack s = new ItemStack(compound.getCompoundTag("item"));
                if (!ItemModUtil.modifierRegistry.get((Object)s.getItem()).countTowardsTotalLevel) continue;
                total += compound.getInteger("level");
            }
        }
        return total;
    }

    public static void setModifierLevel(ItemStack stack, String name, int level) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (!compound.hasKey("name") || compound.getString("name").compareTo(name) != 0) continue;
                compound.setInteger("level", level);
            }
        }
    }

    public static int getModifierLevel(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.getTagCompound().getCompoundTag(HEAT_TAG).getTagList("modifiers", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound compound = list.getCompoundTagAt(i);
                if (!compound.hasKey("name") || compound.getString("name").compareTo(name) != 0) continue;
                return compound.getInteger("level");
            }
        }
        return 0;
    }

    public static float getMaxHeat(ItemStack stack) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey(HEAT_TAG)) {
            return 500.0f + 250.0f * stack.getTagCompound().getCompoundTag(HEAT_TAG).getFloat("heat_level");
        }
        return 0.0f;
    }

    public static float getHeat(ItemStack stack) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey(HEAT_TAG)) {
            return stack.getTagCompound().getCompoundTag(HEAT_TAG).getFloat("heat");
        }
        return 0.0f;
    }

    public static int getLevel(ItemStack stack) {
        ItemModUtil.checkForTag(stack);
        return stack.getTagCompound().getCompoundTag(HEAT_TAG).getInteger("heat_level");
    }

    public static void setLevel(ItemStack stack, int level) {
        ItemModUtil.checkForTag(stack);
        stack.getTagCompound().getCompoundTag(HEAT_TAG).setInteger("heat_level", level);
    }

    public static void addHeat(ItemStack stack, float heat) {
        ItemModUtil.checkForTag(stack);
        stack.getTagCompound().getCompoundTag(HEAT_TAG).setFloat("heat", Math.min(ItemModUtil.getMaxHeat(stack), ItemModUtil.getHeat(stack) + heat));
    }

    public static void setHeat(ItemStack stack, float heat) {
        ItemModUtil.checkForTag(stack);
        stack.getTagCompound().getCompoundTag(HEAT_TAG).setFloat("heat", heat);
    }

    public static boolean hasHeat(ItemStack stack) {
        return !stack.isEmpty() && stack.hasTagCompound() && stack.getTagCompound().hasKey(HEAT_TAG);
    }

    public static int getArmorMod(EntityLivingBase p, String name) {
        int l;
        int maxLevel = 0;
        if (ItemModUtil.hasHeat(p.getItemStackFromSlot(EntityEquipmentSlot.HEAD)) && (l = ItemModUtil.getModifierLevel(p.getItemStackFromSlot(EntityEquipmentSlot.HEAD), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.getItemStackFromSlot(EntityEquipmentSlot.CHEST)) && (l = ItemModUtil.getModifierLevel(p.getItemStackFromSlot(EntityEquipmentSlot.CHEST), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.getItemStackFromSlot(EntityEquipmentSlot.LEGS)) && (l = ItemModUtil.getModifierLevel(p.getItemStackFromSlot(EntityEquipmentSlot.LEGS), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.getItemStackFromSlot(EntityEquipmentSlot.FEET)) && (l = ItemModUtil.getModifierLevel(p.getItemStackFromSlot(EntityEquipmentSlot.FEET), name)) > maxLevel) {
            maxLevel = l;
        }
        return maxLevel;
    }
}

