/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidColorHelper
implements IResourceManagerReloadListener {
    static Map<String, Integer> cache = new HashMap<String, Integer>();

    public static int getColor(FluidStack stack) {
        if (stack == null) {
            return -1;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return -1;
        }
        ResourceLocation still = fluid.getStill(stack);
        if (still == null) {
            return -1;
        }
        TextureMap textureMapBlocks = Minecraft.getMinecraft().getTextureMapBlocks();
        TextureAtlasSprite sprite = textureMapBlocks.getTextureExtry(still.toString());
        if (sprite == null) {
            return -1;
        }
        if (sprite.getFrameCount() == 0) {
            return -1;
        }
        String cacheKey = fluid.getName() + sprite.frameCounter % sprite.getFrameCount();
        if (cache.containsKey(cacheKey)) {
            return FluidColorHelper.finalizeColor(stack, cache.get(cacheKey));
        }
        int totalColor = FluidColorHelper.calculateColor(sprite);
        cache.put(cacheKey, totalColor);
        return FluidColorHelper.finalizeColor(stack, totalColor);
    }

    private static int calculateColor(TextureAtlasSprite sprite) {
        int[][] pixelData = sprite.getFrameTextureData(sprite.frameCounter % sprite.getFrameCount());
        int pixelCount = 0;
        long totalRed = 0L;
        long totalGreen = 0L;
        long totalBlue = 0L;
        long totalAlpha = 0L;
        for (int i = 0; i < pixelData.length; ++i) {
            for (int j = 0; j < pixelData[i].length; ++j) {
                int pixel = pixelData[i][j];
                totalRed += (long)(pixel >> 16 & 0xFF);
                totalGreen += (long)(pixel >> 8 & 0xFF);
                totalBlue += (long)(pixel >> 0 & 0xFF);
                totalAlpha += (long)(pixel >> 24 & 0xFF);
                ++pixelCount;
            }
        }
        return (int)((totalRed /= (long)pixelCount) << 16 | (totalGreen /= (long)pixelCount) << 8 | (totalBlue /= (long)pixelCount) << 0 | (totalAlpha /= (long)pixelCount) << 24);
    }

    public static int finalizeColor(FluidStack stack, int color) {
        Color fluidColor = new Color(color, true);
        Color fluidTint = new Color(stack.getFluid().getColor(stack), true);
        return new Color(fluidColor.getRed() * fluidTint.getRed() / 255, fluidColor.getGreen() * fluidTint.getGreen() / 255, fluidColor.getBlue() * fluidTint.getBlue() / 255, fluidColor.getAlpha() * fluidTint.getAlpha() / 255).getRGB();
    }

    public void onResourceManagerReload(IResourceManager resourceManager) {
        cache.clear();
    }
}

