/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.block.BlockStoneValve;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityLargeTank;

public class TileEntityStoneValve
extends TileEntity
implements ITileEntityBase,
IMultiblockMachine,
ITickable {
    TileEntityLargeTank tank;
    IFluidHandler fluidHandler = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            if (TileEntityStoneValve.this.tank != null) {
                return ((IFluidHandler)TileEntityStoneValve.this.tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties();
            }
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (TileEntityStoneValve.this.tank != null) {
                return ((IFluidHandler)TileEntityStoneValve.this.tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (TileEntityStoneValve.this.tank != null) {
                return ((IFluidHandler)TileEntityStoneValve.this.tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(resource, doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int amount, boolean doDrain) {
            if (TileEntityStoneValve.this.tank != null) {
                return ((IFluidHandler)TileEntityStoneValve.this.tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(amount, doDrain);
            }
            return null;
        }
    };

    public TileEntityLargeTank getTank() {
        return this.tank;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        switch ((Integer)state.getValue((IProperty)BlockStoneValve.state)) {
            case 2: {
                return EnumFacing.WEST;
            }
            case 4: {
                return EnumFacing.SOUTH;
            }
            case 6: {
                return EnumFacing.EAST;
            }
            case 9: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == this.getFacing())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == this.getFacing())) {
            return (T)this.fluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void updateTank() {
        if (this.isInvalid()) {
            return;
        }
        BlockStoneValve valve = (BlockStoneValve)this.getBlockType();
        BlockPos basePos = valve.getMainBlock(this.world, this.pos);
        boolean foundBlock = false;
        for (int i = 0; i < 64 && !foundBlock; ++i) {
            TileEntity tile = this.world.getTileEntity(basePos.add(0, -i, 0));
            if (!(tile instanceof TileEntityLargeTank)) continue;
            this.tank = (TileEntityLargeTank)tile;
            foundBlock = true;
        }
    }

    public void update() {
        if (this.tank == null || this.tank.isInvalid()) {
            this.updateTank();
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.tank != null) {
            return this.tank.activate(world, this.tank.getPos(), world.getBlockState(this.tank.getPos()), player, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }
}

