/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.block.BlockStirling;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeStirling;
import teamroots.embers.util.Misc;

public class TileEntityStirling
extends TileEntity
implements ITickable,
ITileEntityBase,
IExtraDialInformation,
IExtraCapabilityInformation {
    public int activeTicks = 0;
    public UpgradeStirling upgrade;
    public FluidTank tank = new FluidTank(4000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.getFluid((String)"steam");
        }
    };
    private Random random = new Random();

    public TileEntityStirling() {
        this.upgrade = new UpgradeStirling(this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.setTag("tank", (NBTBase)tankTag);
        tag.setInteger("active", this.activeTicks);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.tank.readFromNBT(tag.getCompoundTag("tank"));
        this.activeTicks = tag.getInteger("active");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        if (state.getBlock() instanceof BlockStirling) {
            return (EnumFacing)state.getValue((IProperty)BlockStirling.FACING);
        }
        return null;
    }

    public void setActive(int ticks) {
        this.activeTicks = Math.max(ticks, this.activeTicks);
        this.markDirty();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing() == facing;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFacing().getOpposite() == facing || facing == null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing() == facing) {
            return (T)this.upgrade;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.getFacing().getOpposite() == facing || facing == null)) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        --this.activeTicks;
        IBlockState state = this.world.getBlockState(this.pos);
        if (this.activeTicks > 0 && this.world.isRemote && state.getBlock() instanceof BlockStirling) {
            EnumFacing[] planars;
            EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockStirling.FACING);
            float frontoffset = -0.6f;
            float yoffset = 0.2f;
            float wideoffset = 0.5f;
            float breadthoffset = 0.4f;
            Vec3d frontOffset = new Vec3d(0.5 - (double)((float)facing.getXOffset() * frontoffset), 0.5 - (double)((float)facing.getYOffset() * frontoffset), 0.5 - (double)((float)facing.getZOffset() * frontoffset));
            Vec3d baseOffset = new Vec3d(0.5 - (double)((float)facing.getXOffset() * yoffset), 0.5 - (double)((float)facing.getYOffset() * yoffset), 0.5 - (double)((float)facing.getZOffset() * yoffset));
            switch (facing.getAxis()) {
                case X: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Y: {
                    planars = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Z: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST};
                    break;
                }
                default: {
                    planars = null;
                }
            }
            for (void var13_16 : planars) {
                IBlockState sideState = this.world.getBlockState(this.pos.offset((EnumFacing)var13_16));
                if (sideState.getBlockFaceShape((IBlockAccess)this.world, this.pos.offset((EnumFacing)var13_16), var13_16.getOpposite()) != BlockFaceShape.UNDEFINED) continue;
                EnumFacing cross = facing.rotateAround(var13_16.getAxis());
                float x1 = (float)this.getPos().getX() + (float)baseOffset.x + (float)var13_16.getXOffset() * wideoffset;
                float y1 = (float)this.getPos().getY() + (float)baseOffset.y + (float)var13_16.getYOffset() * wideoffset;
                float z1 = (float)this.getPos().getZ() + (float)baseOffset.z + (float)var13_16.getZOffset() * wideoffset;
                float x2 = (float)this.getPos().getX() + (float)frontOffset.x + (float)var13_16.getXOffset() * wideoffset + (float)cross.getXOffset() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                float y2 = (float)this.getPos().getY() + (float)frontOffset.y + (float)var13_16.getYOffset() * wideoffset + (float)cross.getYOffset() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                float z2 = (float)this.getPos().getZ() + (float)frontOffset.z + (float)var13_16.getZOffset() * wideoffset + (float)cross.getZOffset() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                int lifetime = 24 + this.random.nextInt(8);
                float motionx = (x2 - x1) / (float)lifetime;
                float motiony = (y2 - y1) / (float)lifetime;
                float motionz = (z2 - z1) / (float)lifetime;
                ParticleUtil.spawnParticleVapor(this.getWorld(), x1, y1, z1, motionx, motiony, motionz, 255.0f, 64.0f, 16.0f, 1.0f, 2.0f, 3.0f, lifetime);
            }
            float x = (float)this.getPos().getX() + (float)frontOffset.x;
            float y = (float)this.getPos().getY() + (float)frontOffset.y;
            float z = (float)this.getPos().getZ() + (float)frontOffset.z;
            int n = 16 + this.random.nextInt(16);
            float motionx = (float)(Math.abs(facing.getXOffset()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            float motiony = (float)(Math.abs(facing.getYOffset()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            float motionz = (float)(Math.abs(facing.getZOffset()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            ParticleUtil.spawnParticleVapor(this.getWorld(), x, y, z, motionx, motiony, motionz, 255.0f, 64.0f, 16.0f, 1.0f, 3.0f, 4.0f, n * 2);
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(BlockFluidGauge.formatFluidStack(this.getFluidStack(), this.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.steam", (Object[])new Object[0])));
        }
    }
}

