/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.misc.ILiquidFuel;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockSteamEngine;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntitySteamEngine
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraCapabilityInformation {
    public static int NORMAL_FLUID_THRESHOLD = ConfigMachine.STEAM_ENGINE.fluidThreshold;
    public static int NORMAL_FLUID_CONSUMPTION = ConfigMachine.STEAM_ENGINE.fluidConsumption;
    public static int GAS_CONSUMPTION = ConfigMachine.STEAM_ENGINE.gasConsumption;
    public static double MAX_POWER = ConfigMachine.STEAM_ENGINE.maximumPower;
    public static int CAPACITY = ConfigMachine.STEAM_ENGINE.capacity;
    public static double SOLID_POWER = ConfigMachine.STEAM_ENGINE.fuelPower;
    public static double FUEL_MULTIPLIER = ConfigMachine.STEAM_ENGINE.fuelEfficiency;
    public static final int SOUND_BURN = 1;
    public static final int SOUND_STEAM = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    BurningFuel currentFuel = new BurningFuel();
    int ticksExisted = 0;
    HashSet<Integer> soundsPlaying = new HashSet();
    EnumFacing front = EnumFacing.UP;
    public FluidTank tank = new FluidTank(CAPACITY);
    public DefaultMechCapability capability = new DefaultMechCapability(){

        public void setPower(double value, EnumFacing from) {
            if (from == null) {
                super.setPower(value, null);
            }
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntitySteamEngine.this.markDirty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileEntityFurnace.getItemBurnTime((ItemStack)stack) == 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack currentFuel = super.extractItem(slot, amount, true);
            int burntime = TileEntityFurnace.getItemBurnTime((ItemStack)currentFuel);
            if (burntime != 0) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setDouble("mech_power", this.capability.power);
        tag.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.setTag("progress", (NBTBase)this.currentFuel.writeToNBT(new NBTTagCompound()));
        tag.setInteger("front", this.front.getIndex());
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.power = tag.getDouble("mech_power");
        this.tank.readFromNBT(tag.getCompoundTag("tank"));
        this.currentFuel.readFromNBT(tag.getCompoundTag("progress"));
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        this.front = EnumFacing.byIndex((int)tag.getInteger("front"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return facing == this.front;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return (T)this.capability;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
        if (didFill) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        this.capability.setPower(0.0, null);
        this.updateNearby();
        world.setTileEntity(pos, null);
    }

    public void updateNearby() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.world.getTileEntity(this.getPos().offset(f));
            if (t == null || f != this.front || !t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, Misc.getOppositeFace(f))) continue;
            ((IMechCapability)t.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, Misc.getOppositeFace(f))).setPower(this.capability.getPower(Misc.getOppositeFace(f)), Misc.getOppositeFace(f));
            t.markDirty();
        }
    }

    private ItemStack copyWithSize(ItemStack stack, int size) {
        stack = stack.copy();
        stack.setCount(size);
        return stack;
    }

    public void update() {
        ILiquidFuel fuelHandler;
        FluidStack fluid;
        IBlockState state = this.world.getBlockState(this.getPos());
        if (state.getBlock() instanceof BlockSteamEngine) {
            this.front = (EnumFacing)state.getValue((IProperty)BlockSteamEngine.facing);
        }
        boolean dirty = false;
        double powerGenerated = 0.0;
        if (this.world.isRemote) {
            this.spawnParticles();
            this.handleSound();
        }
        if (!this.world.isRemote && !this.currentFuel.isEmpty()) {
            this.currentFuel.tick();
            if (this.currentFuel.isEmpty()) {
                this.currentFuel.reset();
                dirty = true;
            }
        }
        if (this.currentFuel.isEmpty()) {
            ItemStack fuelCopy;
            int burnTime;
            ItemStack fuel;
            fluid = this.tank.getFluid();
            fuelHandler = EmbersAPI.getSteamEngineFuel(fluid);
            if (fluid != null && fuelHandler != null) {
                fluid = this.tank.drain(Math.min(GAS_CONSUMPTION, Math.max(fluid.amount - 1, 1)), false);
                if (!this.world.isRemote) {
                    this.currentFuel = new BurningFuel(fluid, fuelHandler.getTime(fluid));
                    this.tank.drain(fluid, true);
                    dirty = true;
                }
            } else if (!(this.world.isRemote || this.inventory.getStackInSlot(0).isEmpty() || fluid == null || fluid.getFluid() != FluidRegistry.WATER || this.tank.getFluidAmount() < NORMAL_FLUID_THRESHOLD || (fuel = this.inventory.getStackInSlot(0)).isEmpty() || (burnTime = TileEntityFurnace.getItemBurnTime((ItemStack)(fuelCopy = fuel.copy()))) <= 0)) {
                this.currentFuel = new BurningFuel(this.copyWithSize(fuelCopy, 1), (int)((double)burnTime * FUEL_MULTIPLIER));
                fuel.shrink(1);
                if (fuel.isEmpty()) {
                    this.inventory.setStackInSlot(0, fuelCopy.getItem().getContainerItem(fuelCopy));
                }
                dirty = true;
            }
        }
        if (this.currentFuel.isLiquid()) {
            fluid = this.currentFuel.liquidFuel;
            fuelHandler = EmbersAPI.getSteamEngineFuel(fluid);
            powerGenerated = Misc.getDiminishedPower(fuelHandler.getPower(fluid), MAX_POWER, 1.0);
        }
        if (this.currentFuel.isSolid()) {
            fluid = this.tank.getFluid();
            if (this.tank.getFluidAmount() >= NORMAL_FLUID_CONSUMPTION && fluid != null && fluid.getFluid() == FluidRegistry.WATER) {
                if (!this.world.isRemote) {
                    this.tank.drain(NORMAL_FLUID_CONSUMPTION, true);
                    powerGenerated = SOLID_POWER;
                    dirty = true;
                }
            } else {
                this.currentFuel.reset();
            }
        }
        if (dirty) {
            this.markDirty();
        }
        if (!this.world.isRemote && this.capability.getPower(null) != powerGenerated) {
            this.capability.setPower(powerGenerated, null);
            this.updateNearby();
        }
    }

    private void spawnParticles() {
        if (this.currentFuel.isEmpty()) {
            return;
        }
        boolean vapor = this.currentFuel.isLiquid();
        for (int i = 0; i < 4; ++i) {
            float offX = 0.09375f + 0.8125f * (float)Misc.random.nextInt(2);
            float offZ = 0.28125f + 0.4375f * (float)Misc.random.nextInt(2);
            if (this.front.getAxis() == EnumFacing.Axis.X) {
                float h = offX;
                offX = offZ;
                offZ = h;
            }
            Color color = this.currentFuel.getColor();
            if (vapor) {
                ParticleUtil.spawnParticleVapor(this.world, (float)this.getPos().getX() + offX, (float)this.getPos().getY() + 1.0f, (float)this.getPos().getZ() + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f, 0.5f, 2.0f + Misc.random.nextFloat(), 24);
                continue;
            }
            ParticleUtil.spawnParticleSmoke(this.world, (float)this.getPos().getX() + offX, (float)this.getPos().getY() + 1.0f, (float)this.getPos().getZ() + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f, 2.0f + Misc.random.nextFloat(), 24);
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.pos.getX() + 0.5f;
        float soundY = (float)this.pos.getY() + 0.5f;
        float soundZ = (float)this.pos.getZ() + 0.5f;
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.STEAM_ENGINE_LOOP_BURN, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.world.playSound((double)soundX, (double)soundY, (double)soundZ, SoundManager.STEAM_ENGINE_START_BURN, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.STEAM_ENGINE_LOOP_STEAM, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.world.playSound((double)soundX, (double)soundY, (double)soundZ, SoundManager.STEAM_ENGINE_START_STEAM, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.world.playSound((double)((float)this.pos.getX() + 0.5f), (double)((float)this.pos.getY() + 0.5f), (double)((float)this.pos.getZ() + 0.5f), SoundManager.STEAM_ENGINE_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        switch (id) {
            case 1: {
                return this.currentFuel.isSolid();
            }
            case 2: {
                return this.currentFuel.isLiquid();
            }
        }
        return false;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.fuel", (Object[])new Object[0])));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.water_or_steam", (Object[])new Object[0])));
        }
    }

    static class BurningFuel {
        ItemStack solidFuel = ItemStack.EMPTY;
        FluidStack liquidFuel;
        int timeLeft;

        public BurningFuel() {
        }

        public BurningFuel(ItemStack solidFuel, int timeLeft) {
            this.solidFuel = solidFuel;
            this.timeLeft = timeLeft;
        }

        public BurningFuel(FluidStack liquidFuel, int timeLeft) {
            this.liquidFuel = liquidFuel;
            this.timeLeft = timeLeft;
        }

        public void tick() {
            --this.timeLeft;
        }

        public void reset() {
            this.solidFuel = ItemStack.EMPTY;
            this.liquidFuel = null;
            this.timeLeft = 0;
        }

        public boolean isSolid() {
            return !this.solidFuel.isEmpty();
        }

        public boolean isLiquid() {
            return this.liquidFuel != null;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.liquidFuel != null) {
                tag.setTag("fluid", (NBTBase)this.liquidFuel.writeToNBT(new NBTTagCompound()));
            }
            if (!this.solidFuel.isEmpty()) {
                tag.setTag("item", (NBTBase)this.solidFuel.serializeNBT());
            }
            tag.setInteger("timeLeft", this.timeLeft);
            return tag;
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.hasKey("fluid")) {
                this.liquidFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.getCompoundTag("fluid"));
            }
            if (tag.hasKey("item")) {
                this.solidFuel = new ItemStack(tag.getCompoundTag("item"));
            }
            this.timeLeft = tag.getInteger("timeLeft");
        }

        public boolean isEmpty() {
            return this.timeLeft <= 0;
        }

        public Color getColor() {
            ILiquidFuel fuelHandler;
            if (this.isSolid()) {
                return new Color(72, 72, 72, 128);
            }
            if (this.isLiquid() && (fuelHandler = EmbersAPI.getSteamEngineFuel(this.liquidFuel)) != null) {
                return fuelHandler.getBurnColor(this.liquidFuel);
            }
            return new Color(0, 0, 0, 0);
        }
    }
}

