/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.block.BlockStamper;
import teamroots.embers.tileentity.TileEntityStamper;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.util.StructBox;
import teamroots.embers.util.StructUV;

public class TileEntityStamperRenderer
extends TileEntitySpecialRenderer<TileEntityStamper> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/stamp_top.png");
    RenderItem renderItem = Minecraft.getMinecraft().getRenderItem();
    Random random = new Random();
    public StructBox stampX = new StructBox(0.0, 0.25, 0.25, 1.0, 0.75, 0.75, new StructUV[]{new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0), new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0), new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0), new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0), new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0), new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0)});
    public StructBox stampY = new StructBox(0.25, 0.0, 0.25, 0.75, 1.0, 0.75, new StructUV[]{new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0), new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0), new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0), new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0), new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0), new StructUV(0.0, 0.0, 8.0, 16.0, 32.0, 32.0)});
    public StructBox stampZ = new StructBox(0.25, 0.25, 0.0, 0.75, 0.75, 1.0, new StructUV[]{new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0), new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0), new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0), new StructUV(8.0, 0.0, 16.0, 8.0, 32.0, 32.0), new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0), new StructUV(16.0, 0.0, 32.0, 8.0, 32.0, 32.0)});

    public void render(TileEntityStamper tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.render((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        IBlockState state = tile.getWorld().getBlockState(tile.getPos());
        if (state.getBlock() instanceof BlockStamper) {
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
            float offX = 0.0f;
            float offY = 0.0f;
            float offZ = 0.0f;
            boolean powered = tile.powered;
            boolean prevPowered = tile.prevPowered;
            if (powered) {
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.EAST) {
                    offX = 1.0f;
                }
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.WEST) {
                    offX = -1.0f;
                }
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.NORTH) {
                    offZ = -1.0f;
                }
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.SOUTH) {
                    offZ = 1.0f;
                }
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.UP) {
                    offY = 1.0f;
                }
                if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.DOWN) {
                    offY = -1.0f;
                }
            }
            float magnitude = 0.0f;
            if (!powered) {
                if (prevPowered) {
                    magnitude = 1.0f - partialTicks;
                }
            } else {
                magnitude = !prevPowered ? partialTicks : 1.0f;
            }
            offX *= magnitude;
            offY *= magnitude;
            offZ *= magnitude;
            if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.EAST || state.getValue((IProperty)BlockStamper.facing) == EnumFacing.WEST) {
                RenderUtil.addBox(buffer, this.stampX.x1 + x - 1.0E-4 + (double)offX, this.stampX.y1 + y, this.stampX.z1 + z, this.stampX.x2 + x + 1.0E-4 + (double)offX, this.stampX.y2 + y, this.stampX.z2 + z, this.stampX.textures, new int[]{1, 1, 1, 1, 1, 1});
            }
            if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.UP || state.getValue((IProperty)BlockStamper.facing) == EnumFacing.DOWN) {
                RenderUtil.addBox(buffer, this.stampY.x1 + x, this.stampY.y1 - 1.0E-4 + y + (double)offY, this.stampY.z1 + z, this.stampY.x2 + x, this.stampY.y2 + y + 1.0E-4 + (double)offY, this.stampY.z2 + z, this.stampY.textures, new int[]{1, 1, 1, 1, 1, 1});
            }
            if (state.getValue((IProperty)BlockStamper.facing) == EnumFacing.NORTH || state.getValue((IProperty)BlockStamper.facing) == EnumFacing.SOUTH) {
                RenderUtil.addBox(buffer, this.stampZ.x1 + x, this.stampZ.y1 + y, this.stampZ.z1 - 1.0E-4 + z + (double)offZ, this.stampZ.x2 + x, this.stampZ.y2 + y, this.stampZ.z2 + 1.0E-4 + z + (double)offZ, this.stampZ.textures, new int[]{1, 1, 1, 1, 1, 1});
            }
            tess.draw();
            ItemStack stamp = tile.stamp.getStackInSlot(0);
            if (!stamp.isEmpty()) {
                GlStateManager.pushMatrix();
                GlStateManager.translate((double)x, (double)y, (double)z);
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                GlStateManager.translate((float)0.0f, (float)(-0.53125f - magnitude * 1.0f), (float)0.0f);
                GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.scale((float)0.7f, (float)1.0f, (float)0.7f);
                GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.getMinecraft().getRenderItem().renderItem(stamp, ItemCameraTransforms.TransformType.NONE);
                GlStateManager.popMatrix();
            }
        }
    }
}

