/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import teamroots.embers.block.BlockStampBase;
import teamroots.embers.tileentity.TileEntityStampBase;

public class TileEntityStampBaseRenderer
extends TileEntitySpecialRenderer<TileEntityStampBase> {
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityStampBase tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null && !tile.getWorld().isAirBlock(tile.getPos()) && tile.getWorld().getBlockState(tile.getPos()).getBlock() instanceof BlockStampBase) {
            EnumFacing face = (EnumFacing)tile.getWorld().getBlockState(tile.getPos()).getValue((IProperty)BlockStampBase.facing);
            int capacity = tile.getCapacity();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            FluidStack fluidStack = tile.getFluidStack();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                this.blue = c & 0xFF;
                this.green = c >> 8 & 0xFF;
                this.red = c >> 16 & 0xFF;
                this.alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.getMinU() + this.diffU * 0.25;
                this.maxU = (double)sprite.getMaxU() - this.diffU * 0.25;
                this.minV = (double)sprite.getMinV() + this.diffV * 0.25;
                this.maxV = (double)sprite.getMaxV() - this.diffV * 0.25;
                int i = this.getWorld().getCombinedLight(tile.getPos(), fluid.getLuminosity(fluidStack));
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                GlStateManager.disableCull();
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.enableAlpha();
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                if (face == EnumFacing.UP) {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.NORTH) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.SOUTH) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.EAST) {
                    GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                Tessellator tess = Tessellator.getInstance();
                BufferBuilder buffer = tess.getBuffer();
                buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
                buffer.pos(0.25, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.25).tex(this.minU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(0.75, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.25).tex(this.maxU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(0.75, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.75).tex(this.maxU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(0.25, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.75).tex(this.minU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                tess.draw();
                GL11.glPopMatrix();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                GlStateManager.enableLighting();
                GlStateManager.enableCull();
            }
            if (!tile.inputs.getStackInSlot(0).isEmpty()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                GL11.glTranslated((double)0.5, (double)0.75, (double)0.5);
                if (face == EnumFacing.UP) {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.NORTH) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.SOUTH) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.EAST) {
                    GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                Random random = new Random();
                ItemStack stack = tile.inputs.getStackInSlot(0);
                random.setSeed(stack.isEmpty() ? 187 : Item.getIdFromItem((Item)stack.getItem()) + stack.getMetadata());
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                for (int j = 0; j < Math.min(stack.getCount(), 6); ++j) {
                    GlStateManager.pushMatrix();
                    float f7 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    if (stack.getCount() > 1) {
                        GlStateManager.translate((float)f7, (float)f9, (float)f6);
                    }
                    Minecraft.getMinecraft().getRenderItem().renderItem(stack, ItemCameraTransforms.TransformType.GROUND);
                    GlStateManager.popMatrix();
                }
                GL11.glPopMatrix();
            }
        }
    }
}

