/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.tile.IEmberInjectable;
import teamroots.embers.block.BlockSeed;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

@Deprecated
public class TileEntitySeed
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberInjectable,
ISoundController {
    boolean[] willSpawn = new boolean[12];
    public static ResourceLocation TEXTURE_IRON = new ResourceLocation("embers:textures/blocks/material_iron.png");
    public static ResourceLocation TEXTURE_GOLD = new ResourceLocation("embers:textures/blocks/material_gold.png");
    public static ResourceLocation TEXTURE_COPPER = new ResourceLocation("embers:textures/blocks/material_copper.png");
    public static ResourceLocation TEXTURE_LEAD = new ResourceLocation("embers:textures/blocks/material_lead.png");
    public static ResourceLocation TEXTURE_SILVER = new ResourceLocation("embers:textures/blocks/material_silver.png");
    protected int size = 0;
    protected int ticksExisted = 0;
    protected int material = -1;
    protected Random random = new Random();
    public static final int SOUND_AMBIENT = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntitySeed() {
        this.resetSpawns();
    }

    public void resetSpawns() {
        for (int i = 0; i < 12; ++i) {
            this.willSpawn[i] = this.random.nextInt(3) == 0;
        }
    }

    public TileEntitySeed setMaterial(int material) {
        this.material = material;
        return this;
    }

    public String getSpawnString() {
        String result = "";
        for (int i = 0; i < 12; ++i) {
            result = result + (this.willSpawn[i] ? "1" : "0");
        }
        return result;
    }

    public void loadSpawnsFromString(String s) {
        for (int i = 0; i < 12; ++i) {
            this.willSpawn[i] = s.substring(i, i + 1).compareTo("1") == 0;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setString("spawns", this.getSpawnString());
        tag.setInteger("size", this.size);
        tag.setInteger("material", this.material);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.loadSpawnsFromString(tag.getString("spawns"));
        this.size = tag.getInteger("size");
        this.material = tag.getInteger("material");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        if (this.material == -1) {
            this.material = (Integer)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockSeed.type);
        }
        ++this.ticksExisted;
        if (this.size > 1000) {
            this.size = 0;
            for (int i = 0; i < 12; ++i) {
                if (!this.willSpawn[i] || this.getWorld().isRemote) continue;
                ItemStack nuggetStack = this.getDrop();
                float offX = 0.4f * (float)Math.sin(Math.toRadians((double)i * 30.0));
                float offZ = 0.4f * (float)Math.cos(Math.toRadians((double)i * 30.0));
                this.world.spawnEntity((Entity)new EntityItem(this.world, (double)this.getPos().getX() + 0.5 + (double)offX, (double)((float)this.getPos().getY() + 0.5f), (double)this.getPos().getZ() + 0.5 + (double)offZ, nuggetStack));
                this.world.playSound(null, (double)this.getPos().getX() + 0.5 + (double)offX, (double)((float)this.getPos().getY() + 0.5f), (double)this.getPos().getZ() + 0.5 + (double)offZ, SoundManager.METAL_SEED_PING, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.markDirty();
            this.resetSpawns();
        }
    }

    protected ItemStack getDrop() {
        switch (this.material) {
            case 0: {
                return new ItemStack(Items.IRON_NUGGET, 1);
            }
            case 1: {
                return new ItemStack(Items.GOLD_NUGGET, 1);
            }
            case 2: {
                return new ItemStack(ItemRegister.NUGGET_COPPER, 1);
            }
            case 3: {
                return new ItemStack(ItemRegister.NUGGET_LEAD, 1);
            }
            case 4: {
                return new ItemStack(ItemRegister.NUGGET_SILVER, 1);
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void inject(TileEntity injector, double ember) {
        ++this.size;
        this.markDirty();
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.METAL_SEED_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public ResourceLocation getTexture() {
        switch (this.material) {
            case 0: {
                return TEXTURE_IRON;
            }
            case 1: {
                return TEXTURE_GOLD;
            }
            case 2: {
                return TEXTURE_COPPER;
            }
            case 3: {
                return TEXTURE_LEAD;
            }
            case 4: {
                return TEXTURE_SILVER;
            }
        }
        return TEXTURE_IRON;
    }
}

