/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityCatalyzer;
import teamroots.embers.tileentity.TileEntityCombustor;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityReactor
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double BASE_MULTIPLIER = ConfigMachine.REACTOR.base_multiplier;
    public static final int PROCESS_TIME = ConfigMachine.REACTOR.process_time;
    public static final double EMBER_CAPACITY = ConfigMachine.REACTOR.capacity;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityReactor.this.markDirty();
        }

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    Random random = new Random();
    int progress = -1;
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();
    public static final int SOUND_HAS_EMBER = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityReactor.this.markDirty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmbersAPI.getEmberValue(stack) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private double catalyzerMult;
    private double combustorMult;

    public TileEntityReactor() {
        this.capability.setEmberCapacity(EMBER_CAPACITY);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        this.capability.readFromNBT(tag);
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(this.getWorld(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        boolean cancel;
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.HORIZONTALS);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        if (!(cancel = UpgradeUtil.doWork(this, this.upgrades)) && !this.inventory.getStackInSlot(0).isEmpty()) {
            ++this.progress;
            if (this.progress > UpgradeUtil.getWorkTime(this, PROCESS_TIME, this.upgrades)) {
                this.catalyzerMult = 0.0;
                this.combustorMult = 0.0;
                double multiplier = BASE_MULTIPLIER;
                for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                    TileEntity tile = this.world.getTileEntity(this.getPos().offset(facing).down());
                    if (tile instanceof TileEntityCatalyzer) {
                        this.catalyzerMult += ((TileEntityCatalyzer)tile).multiplier;
                    }
                    if (!(tile instanceof TileEntityCombustor)) continue;
                    this.combustorMult += ((TileEntityCombustor)tile).multiplier;
                }
                if (Math.max(this.combustorMult, this.catalyzerMult) < 2.0 * Math.min(this.combustorMult, this.catalyzerMult)) {
                    ItemStack emberStack;
                    double emberValue;
                    double ember;
                    multiplier += this.combustorMult;
                    multiplier += this.catalyzerMult;
                    this.progress = 0;
                    int i = 0;
                    if (this.inventory != null && (ember = UpgradeUtil.getTotalEmberProduction(this, multiplier * (emberValue = EmbersAPI.getEmberValue(emberStack = this.inventory.getStackInSlot(i))), this.upgrades)) > 0.0 && this.capability.getEmber() + ember <= this.capability.getEmberCapacity()) {
                        if (!this.world.isRemote) {
                            this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, SoundManager.IGNEM_REACTOR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.getPos().getX() + 0.5f, (float)this.getPos().getY() + 0.5f, (float)this.getPos().getZ() + 0.5f));
                        }
                        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.PRODUCE, ember), this.upgrades);
                        this.capability.addAmount(ember, true);
                        this.inventory.extractItem(i, 1, false);
                        this.markDirty();
                    }
                }
            }
            this.markDirty();
        }
        if (this.capability.getEmber() > 0.0 && this.getWorld().isRemote) {
            double catalyzerRatio = 0.0;
            if (this.catalyzerMult > 0.0 || this.combustorMult > 0.0) {
                catalyzerRatio = this.catalyzerMult / (this.catalyzerMult + this.combustorMult);
            }
            int r = (int)MathHelper.clampedLerp((double)255.0, (double)255.0, (double)catalyzerRatio);
            int g = (int)MathHelper.clampedLerp((double)64.0, (double)64.0, (double)catalyzerRatio);
            int b = (int)MathHelper.clampedLerp((double)16.0, (double)64.0, (double)catalyzerRatio);
            int i = 0;
            while ((double)i < Math.ceil(this.capability.getEmber() / 500.0)) {
                float vx = (float)MathHelper.clampedLerp((double)0.0, (double)(((double)this.random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                float vy = (float)MathHelper.clampedLerp((double)(this.random.nextFloat() * 0.05f), (double)(((double)this.random.nextFloat() - 0.5) * (double)0.2f), (double)catalyzerRatio);
                float vz = (float)MathHelper.clampedLerp((double)0.0, (double)(((double)this.random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                float size = (float)MathHelper.clampedLerp((double)4.0, (double)2.0, (double)catalyzerRatio);
                int lifetime = 16 + this.random.nextInt(16);
                ParticleUtil.spawnParticleGlow(this.getWorld(), (float)this.getPos().getX() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.getPos().getY() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.getPos().getZ() + 0.25f + this.random.nextFloat() * 0.5f, vx, vy, vz, r, g, b, size, lifetime);
                ++i;
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.GENERATOR_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.capability.getEmber() > 0.0;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType) && Math.max(this.combustorMult, this.catalyzerMult) < 2.0 * Math.min(this.combustorMult, this.catalyzerMult)) {
            DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = BASE_MULTIPLIER + this.combustorMult + this.catalyzerMult;
            information.add(I18n.format((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return true;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.ember", null));
        }
    }
}

