/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public abstract class TileEntityOpenTank
extends TileFluidHandler {
    FluidStack lastEscaped = null;
    long lastEscapedTickServer;
    long lastEscapedTickClient;

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound compound = super.writeToNBT(tag);
        if (this.lastEscaped != null) {
            compound.setTag("lastEscaped", (NBTBase)this.lastEscaped.writeToNBT(new NBTTagCompound()));
            compound.setLong("lastEscapedTick", this.lastEscapedTickServer);
        }
        return compound;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("lastEscaped")) {
            this.lastEscaped = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.getCompoundTag("lastEscaped"));
            this.lastEscapedTickServer = tag.getLong("lastEscapedTick");
        }
    }

    public void setEscapedFluid(FluidStack stack) {
        this.lastEscaped = stack;
        this.lastEscapedTickServer = this.world.getTotalWorldTime();
        this.markDirty();
    }

    protected boolean shouldEmitParticles() {
        if (this.lastEscaped == null) {
            return false;
        }
        if (this.lastEscapedTickClient < this.lastEscapedTickServer) {
            this.lastEscapedTickClient = this.lastEscapedTickServer;
            return true;
        }
        long dTime = this.world.getTotalWorldTime() - this.lastEscapedTickClient;
        return dTime < (long)(this.lastEscaped.amount + 5);
    }

    protected abstract void updateEscapeParticles();
}

