/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mysticalmechanics.api.GearHelper;
import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeActuator;
import teamroots.embers.util.ConsumerMechCapability;
import teamroots.embers.util.Misc;

public class TileEntityMechActuator
extends TileEntity
implements ITickable,
ITileEntityBase,
IGearbox,
IExtraCapabilityInformation {
    public UpgradeActuator upgrade;
    public GearHelperTile[] gears = new GearHelperTile[6];
    public boolean shouldUpdate;
    private Random random = new Random();
    public ConsumerMechCapability capability = new ConsumerMechCapability(){

        @Override
        public void onPowerChange() {
            TileEntityMechActuator box = TileEntityMechActuator.this;
            TileEntityMechActuator.this.shouldUpdate = true;
            box.markDirty();
        }

        public double getVisualPower(EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.getExternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformVisualPower((TileEntity)TileEntityMechActuator.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        @Override
        public double getPower(EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            return super.getPower(from);
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (this.isInput(from) && gearHelper.isEmpty()) {
                super.setPower(0.0, from);
            }
            if (this.isInput(from)) {
                this.powerExternal[from.getIndex()] = value;
                if (!gearHelper.isEmpty()) {
                    IGearBehavior behavior = gearHelper.getBehavior();
                    value = behavior.transformPower((TileEntity)TileEntityMechActuator.this, from, gearHelper.getGear(), gearHelper.getData(), value);
                    super.setPower(value, from);
                }
            }
        }

        public boolean isInput(EnumFacing from) {
            return TileEntityMechActuator.this.canAttachGear(from);
        }
    };

    private GearHelper getGearHelper(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        return this.gears[facing.getIndex()];
    }

    public TileEntityMechActuator() {
        this.upgrade = new UpgradeActuator(this);
        for (int i = 0; i < this.gears.length; ++i) {
            this.gears[i] = new GearHelperTile((TileEntity)this, EnumFacing.byIndex((int)i));
        }
        this.capability.setAdditive(true);
    }

    public void updateNeighbors() {
        for (EnumFacing f : EnumFacing.VALUES) {
            MysticalMechanicsAPI.IMPL.pullPower((TileEntity)this, f, (IMechCapability)this.capability, !this.getGear(f).isEmpty());
        }
        this.markDirty();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        int i;
        super.writeToNBT(tag);
        for (i = 0; i < 6; ++i) {
            tag.setTag("side" + i, (NBTBase)this.gears[i].writeToNBT(new NBTTagCompound()));
        }
        this.capability.writeToNBT(tag);
        for (i = 0; i < 6; ++i) {
            tag.setDouble("mech_power" + i, this.capability.power[i]);
        }
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        int i;
        super.readFromNBT(tag);
        for (i = 0; i < 6; ++i) {
            this.gears[i].readFromNBT(tag.getCompoundTag("side" + i));
        }
        this.readLegacyGears(tag);
        for (i = 0; i < 6; ++i) {
            this.capability.power[i] = tag.getDouble("mech_power" + i);
        }
        this.capability.readFromNBT(tag);
        this.capability.markDirty();
    }

    private void readLegacyGears(NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            if (!tag.hasKey("gear" + i)) continue;
            this.gears[i].setGear(new ItemStack(tag.getCompoundTag("gear" + i)));
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        if (state.getBlock() instanceof BlockMechActuator) {
            return (EnumFacing)state.getValue((IProperty)BlockMechActuator.facing);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing().getOpposite() == facing;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return facing == null || this.canAttachGear(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().getOpposite() == facing) {
            return (T)this.upgrade;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (facing == null || this.canAttachGear(facing))) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    private double getGearInPower(EnumFacing facing) {
        return this.capability.getExternalPower(facing);
    }

    private double getGearOutPower(EnumFacing facing) {
        return this.capability.getInternalPower(facing);
    }

    public void update() {
        if (this.shouldUpdate) {
            this.updateNeighbors();
            this.shouldUpdate = false;
        }
        for (EnumFacing facing : EnumFacing.VALUES) {
            int i = facing.getIndex();
            if (this.world.isRemote) {
                this.gears[i].visualUpdate(this.getGearInPower(facing), this.capability.getVisualPower(facing));
            }
            this.gears[i].tick(this.getGearInPower(facing), this.getGearOutPower(facing));
            if (!this.gears[i].isDirty()) continue;
            this.shouldUpdate = true;
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty() && this.canAttachGear(side, heldItem)) {
            if (this.getGear(side).isEmpty() && MysticalMechanicsAPI.IMPL.isValidGear(heldItem)) {
                ItemStack gear = heldItem.copy();
                gear.setCount(1);
                this.attachGear(side, gear, player);
                heldItem.shrink(1);
                if (heldItem.isEmpty()) {
                    player.setHeldItem(hand, ItemStack.EMPTY);
                }
                this.capability.onPowerChange();
                return true;
            }
        } else if (!this.getGear(side).isEmpty()) {
            ItemStack gear = this.detachGear(side, player);
            if (!world.isRemote) {
                world.spawnEntity((Entity)new EntityItem(world, player.posX, player.posY + (double)(player.height / 2.0f), player.posZ, gear));
            }
            this.capability.onPowerChange();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.gears[i].detach(player);
            if (world.isRemote) continue;
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack));
        }
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void attachGear(EnumFacing facing, ItemStack stack, @Nullable EntityPlayer player) {
        if (!this.canAttachGear(facing)) {
            return;
        }
        this.gears[facing.getIndex()].attach(player, stack);
        this.markDirty();
    }

    public ItemStack detachGear(EnumFacing facing, @Nullable EntityPlayer player) {
        if (!this.canAttachGear(facing)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.gears[facing.getIndex()].detach(player);
        this.markDirty();
        return stack;
    }

    public ItemStack getGear(EnumFacing facing) {
        if (!this.canAttachGear(facing)) {
            return ItemStack.EMPTY;
        }
        return this.gears[facing.getIndex()].getGear();
    }

    public boolean canAttachGear(EnumFacing facing, ItemStack stack) {
        return this.canAttachGear(facing);
    }

    public boolean canAttachGear(EnumFacing facing) {
        return facing != null && this.getFacing().getAxis() != facing.getAxis();
    }

    public int getConnections() {
        return 1;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return false;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
    }
}

