/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.tileentity.TileEntityLargeTank;

public class TileEntityLargeTankRenderer
extends TileEntitySpecialRenderer<TileEntityLargeTank> {
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityLargeTank tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            FluidStack fluidStack = tile.getFluidStack();
            int capacity = tile.getCapacity();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                this.blue = c & 0xFF;
                this.green = c >> 8 & 0xFF;
                this.red = c >> 16 & 0xFF;
                this.alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = sprite.getMinU();
                this.maxU = sprite.getMaxU();
                this.minV = sprite.getMinV();
                this.maxV = sprite.getMaxV();
                int i = this.getWorld().getCombinedLight(tile.getPos(), fluid.getLuminosity(fluidStack));
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                GlStateManager.disableCull();
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.enableAlpha();
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                Tessellator tess = Tessellator.getInstance();
                BufferBuilder buffer = tess.getBuffer();
                buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
                buffer.pos(x - 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z - 0.5).tex(this.minU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z - 0.5).tex(this.maxU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.maxU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x - 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.minU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z - 0.5).tex(this.minU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 1.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z - 0.5).tex(this.maxU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 1.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.maxU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.minU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.minU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 1.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.maxU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 1.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 1.5).tex(this.maxU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 1.5).tex(this.minU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x - 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.minU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 0.5).tex(this.maxU, this.minV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x + 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 1.5).tex(this.maxU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                buffer.pos(x - 0.5, y + 0.875 + 1.0 * (double)((float)amount / 40000.0f), z + 1.5).tex(this.minU, this.maxV).lightmap(this.lightx, this.lighty).color(this.red, this.green, this.blue, this.alpha).endVertex();
                tess.draw();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                GlStateManager.enableLighting();
            }
        }
    }
}

