/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.block.BlockStoneEdge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.FluidColorHelper;
import teamroots.embers.util.Misc;

public class TileEntityLargeTank
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    int ticksExisted = 0;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().expand(4.0, 256.0, 4.0);
    }

    public TileEntityLargeTank() {
        this.tank = new FluidTank(Integer.MAX_VALUE){

            public void onContentsChanged() {
                TileEntityLargeTank.this.markDirty();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityLargeTank.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return super.fill(resource, doFill);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean didFill;
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty() && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setBlockToAir(pos.add(1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, -1));
        world.setBlockToAir(pos.add(1, 0, -1));
        world.setBlockToAir(pos.add(-1, 0, 1));
        world.setBlockToAir(pos.add(1, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, -1));
        world.setTileEntity(pos, null);
    }

    public void updateCapacity() {
        int capacity = 0;
        int i = 1;
        while (this.isReservoirPart(this.getPos().add(0, i, 0))) {
            capacity += ConfigMachine.RESERVOIR.capacity;
            ++i;
        }
        if (this.tank.getCapacity() != capacity) {
            this.tank.setCapacity(capacity);
            int amount = this.tank.getFluidAmount();
            if (amount > capacity) {
                this.tank.drain(amount - capacity, true);
            }
            this.markDirty();
        }
    }

    protected boolean isReservoirPart(BlockPos pos) {
        IBlockState state = this.getWorld().getBlockState(pos);
        return state.getBlock() instanceof BlockStoneEdge && (Integer)state.getValue((IProperty)BlockStoneEdge.state) == 8;
    }

    public void update() {
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0) {
            this.updateCapacity();
        }
        if (this.world.isRemote && this.shouldEmitParticles()) {
            this.updateEscapeParticles();
        }
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(FluidColorHelper.getColor(this.lastEscaped), true);
        Random random = new Random();
        int height = this.getCapacity() / ConfigMachine.RESERVOIR.capacity;
        for (int i = 0; i < 3; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f;
            float yOffset = (float)height + 0.9f;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f;
            ParticleUtil.spawnParticleVapor(this.world, (float)this.pos.getX() + xOffset, (float)this.pos.getY() + yOffset, (float)this.pos.getZ() + zOffset, 0.0f, 0.05f, 0.0f, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 8.0f, 6.0f, 50);
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE((TileEntity)this);
    }
}

