/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import teamroots.embers.tileentity.TileEntityItemRequisition;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;

public class TileEntityItemRequisitionRenderer
extends TileEntitySpecialRenderer<TileEntityItemRequisition> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/item_pipe_tex.png");

    public void render(TileEntityItemRequisition tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
            for (EnumFacing facing : EnumFacing.VALUES) {
                if (this.shouldRenderPipe(tile, facing)) {
                    PipeRenderUtil.addPipe(buffer, x, y, z, facing);
                }
                if (!this.shouldRenderLip(tile, facing)) continue;
                PipeRenderUtil.addPipeLip(buffer, x, y, z, facing);
            }
            tess.draw();
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            GL11.glPushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.enableCull();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            GL11.glRotated((double)(tile.angle + tile.turnRate * (double)partialTicks), (double)0.0, (double)1.0, (double)0.0);
            ItemStack filterItem = tile.filterItem;
            IBakedModel model = Minecraft.getMinecraft().getRenderItem().getItemModelWithOverrides(filterItem, tile.getWorld(), null);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.color((float)0.1f, (float)0.0f, (float)0.0f, (float)0.1f);
            this.renderItem(filterItem, model);
            GL11.glPopMatrix();
        }
    }

    public void renderItem(ItemStack stack, IBakedModel model) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.5f;
        if (!stack.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.isBuiltInRenderer()) {
                GlStateManager.color((float)r, (float)g, (float)b, (float)a);
                GlStateManager.enableRescaleNormal();
                stack.getItem().getTileEntityItemStackRenderer().renderByItem(stack);
            } else {
                Color color = new Color(r, g, b, a);
                Minecraft.getMinecraft().getRenderItem().renderModel(model, color.getRGB(), stack);
            }
            GlStateManager.popMatrix();
        }
    }

    private boolean shouldRenderLip(TileEntityItemRequisition pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    private boolean shouldRenderPipe(TileEntityItemRequisition pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.PIPE || this.shouldRenderLip(pipe, facing);
    }
}

