/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import teamroots.embers.Embers;
import teamroots.embers.api.filter.FilterExisting;
import teamroots.embers.api.filter.FilterItem;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.item.IFilterItem;
import teamroots.embers.api.tile.IOrderDestination;
import teamroots.embers.api.tile.IOrderSource;
import teamroots.embers.api.tile.ITargetable;
import teamroots.embers.block.BlockItemRequisition;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.ISpecialFilter;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityItemExtractor;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityItemRequisition
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipePriority,
IItemPipeConnectable,
ITargetable,
IOrderSource,
ISpecialFilter {
    public static final int PRIORITY_REQUEST = -100;
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.VALUES.length];
    public IItemHandler itemHandler;
    public ItemStack filterItem = ItemStack.EMPTY;
    public int filterSize = 0;
    IFilter filter = FilterUtil.FILTER_ANY;
    public int currentOrder;
    public BlockPos target = null;
    double angle = 0.0;
    double turnRate = 1.0;
    boolean lastPowered;

    public TileEntityItemRequisition() {
        this.itemHandler = new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return ItemStack.EMPTY;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!TileEntityItemRequisition.this.acceptsItem(stack)) {
                    return stack;
                }
                TileEntity attached = TileEntityItemRequisition.this.getAttached();
                if (attached != null && attached.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityItemRequisition.this.getFacing().getOpposite())) {
                    IItemHandler handler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityItemRequisition.this.getFacing().getOpposite());
                    if (TileEntityItemRequisition.this.isIntelligent()) {
                        ItemStack split = stack.copy();
                        for (int j = 0; j < handler.getSlots() && !split.isEmpty(); ++j) {
                            split = handler.insertItem(j, split, simulate);
                        }
                        return split;
                    }
                    int count = TileEntityItemRequisition.this.countItems(handler);
                    int filterSize = TileEntityItemRequisition.this.getFilterSize() - count;
                    if (filterSize > 0) {
                        ItemStack whole = stack.copy();
                        ItemStack split = whole.splitStack(filterSize);
                        for (int j = 0; j < handler.getSlots() && !split.isEmpty(); ++j) {
                            split = handler.insertItem(j, split, simulate);
                        }
                        ItemStack merged = this.merge(whole, split);
                        return merged;
                    }
                }
                return stack;
            }

            ItemStack merge(ItemStack first, ItemStack second) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)first, (ItemStack)second)) {
                    return first;
                }
                first = first.copy();
                first.grow(second.getCount());
                return first;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    public void updateConnections() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setInternalConnection(facing, this.getConnection((IBlockAccess)this.world, this.getPos().offset(facing), facing));
        }
        this.markDirty();
    }

    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.getIndex()] != null ? this.connections[facing.getIndex()] : EnumPipeConnection.NONE;
    }

    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.getIndex()] = connection;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        return facing == this.getFacing() ? EnumPipeConnection.NONE : EnumPipeConnection.PIPE;
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.getTileEntity(pos);
        if (side == this.getFacing() || tile instanceof TileEntityItemRequisition) {
            return EnumPipeConnection.NONE;
        }
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(side.getOpposite());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.getOpposite())) {
            return EnumPipeConnection.PIPE;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public boolean isIntelligent() {
        return this.filter instanceof FilterExisting;
    }

    private void setupFilter() {
        Item item = this.filterItem.getItem();
        this.filter = item instanceof IFilterItem ? ((IFilterItem)item).getFilter(this.filterItem) : (!this.filterItem.isEmpty() ? new FilterItem(this.filterItem) : FilterUtil.FILTER_ANY);
    }

    public int getFilterSize() {
        return this.filterSize;
    }

    public boolean acceptsItem(ItemStack stack) {
        IItemHandler itemHandler;
        TileEntity attached = this.getAttached();
        if (attached != null && (itemHandler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().getOpposite())) != null) {
            return this.filter.acceptsItem(stack, itemHandler);
        }
        return false;
    }

    private EnumFacing getFacing() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        return (EnumFacing)state.getValue((IProperty)BlockItemRequisition.facing);
    }

    public TileEntity getAttached() {
        return this.world.getTileEntity(this.pos.offset(this.getFacing()));
    }

    public TileEntityItemExtractor getSource() {
        if (this.target == null) {
            return null;
        }
        TileEntity tile = this.world.getTileEntity(this.target);
        if (tile instanceof TileEntityItemExtractor) {
            return (TileEntityItemExtractor)tile;
        }
        return null;
    }

    @Override
    public IItemHandler getItemHandler() {
        IItemHandler itemHandler;
        TileEntity attached = this.getAttached();
        if (attached != null && (itemHandler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().getOpposite())) != null) {
            return itemHandler;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getFacing()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getFacing()) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        if (!this.world.isRemote) {
            boolean isPowered = false;
            isPowered = this.getWorld().isBlockPowered(this.getPos());
            int filterSize = this.getFilterSize();
            TileEntity attached = this.getAttached();
            int count = 0;
            if (attached != null && attached.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().getOpposite())) {
                IItemHandler handler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().getOpposite());
                count = this.countItems(handler);
            }
            if (this.currentOrder < filterSize - count) {
                this.order(filterSize - count - this.currentOrder);
            } else if (this.currentOrder > filterSize - count) {
                this.currentOrder = Math.max(0, filterSize - count);
            }
            this.lastPowered = isPowered;
        } else {
            this.angle += this.turnRate;
        }
    }

    public int countItems(IItemHandler handler) {
        int count = 0;
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack countStack = handler.getStackInSlot(j);
            if (!this.acceptsItem(countStack)) continue;
            count += countStack.getCount();
        }
        return count;
    }

    public void order(int orderSize) {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            source.order(this, this.filter, orderSize);
            this.currentOrder += orderSize;
        }
    }

    public void resetOrder() {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            source.resetOrder(this);
        }
        this.currentOrder = 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("order", this.currentOrder);
        if (!this.filterItem.isEmpty()) {
            tag.setTag("filter", (NBTBase)this.filterItem.writeToNBT(new NBTTagCompound()));
            tag.setInteger("filterSize", this.filterSize);
        } else {
            tag.setString("filter", "empty");
        }
        if (this.target != null) {
            tag.setInteger("targetX", this.target.getX());
            tag.setInteger("targetY", this.target.getY());
            tag.setInteger("targetZ", this.target.getZ());
        }
        tag.setInteger("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.setInteger("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.setInteger("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.setInteger("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.setInteger("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.setInteger("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
        tag.setBoolean("lastPowered", this.lastPowered);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.currentOrder = tag.getInteger("order");
        if (tag.hasKey("filter")) {
            this.filterItem = new ItemStack(tag.getCompoundTag("filter"));
            this.filterSize = tag.getInteger("filterSize");
        }
        if (tag.hasKey("targetX")) {
            this.target = new BlockPos(tag.getInteger("targetX"), tag.getInteger("targetY"), tag.getInteger("targetZ"));
        }
        if (tag.hasKey("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.getInteger("up")));
        }
        if (tag.hasKey("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.getInteger("down")));
        }
        if (tag.hasKey("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.getInteger("north")));
        }
        if (tag.hasKey("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.getInteger("south")));
        }
        if (tag.hasKey("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.getInteger("west")));
        }
        if (tag.hasKey("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.getInteger("east")));
        }
        this.lastPowered = tag.getBoolean("lastPowered");
        this.setupFilter();
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (heldItem.getItem() instanceof ItemTinkerHammer) {
            return false;
        }
        if (player.isSneaking()) {
            return false;
        }
        if (!world.isRemote) {
            if (heldItem != ItemStack.EMPTY) {
                if (!this.filterItem.isItemEqual(heldItem)) {
                    this.filterItem = heldItem.copy();
                    this.filterSize = this.filterItem.getCount();
                } else {
                    this.filterSize += heldItem.getCount();
                }
            } else {
                this.filterItem = ItemStack.EMPTY;
                this.filterSize = 0;
            }
            this.setupFilter();
            this.resetOrder();
            this.markDirty();
            return true;
        }
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.resetOrder();
    }

    @Override
    public void setTarget(BlockPos pos) {
        TileEntity tile = this.world.getTileEntity(pos);
        if (tile instanceof IOrderDestination) {
            this.resetOrder();
            this.target = pos;
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void addDescription(List<String> strings) {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            BlockPos pos = source.getPos();
            IBlockState blockState = this.world.getBlockState(pos);
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.linked", blockState.getBlock().getLocalizedName(), pos.getX(), pos.getY(), pos.getZ()));
        }
        strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.filter", this.filter.formatFilter(), this.getFilterSize()));
        if (this.currentOrder > 0) {
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.order", this.currentOrder));
        } else {
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.order.none", new Object[0]));
        }
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return -100;
    }

    @Override
    public IFilter getSpecialFilter() {
        return FilterUtil.FILTER_EXISTING;
    }
}

