/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.tileentity.TileEntityBaseGauge;

public class TileEntityItemGauge
extends TileEntityBaseGauge {
    @Override
    public int calculateComparatorValue(TileEntity tileEntity, EnumFacing facing) {
        int comparatorValue = 0;
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < handler.getSlots(); ++j) {
                ItemStack itemstack = handler.getStackInSlot(j);
                if (itemstack.isEmpty()) continue;
                f += (float)itemstack.getCount() / (float)Math.min(handler.getSlotLimit(j), itemstack.getMaxStackSize());
                ++i;
            }
            comparatorValue = MathHelper.floor((float)((f /= (float)handler.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        if (tileEntity instanceof IExtraDialInformation) {
            comparatorValue = ((IExtraDialInformation)tileEntity).getComparatorData(facing, comparatorValue, this.getDialType());
        }
        return comparatorValue;
    }

    @Override
    public String getDialType() {
        return "item";
    }
}

