/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.SoundManager;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.tile.IOrderDestination;
import teamroots.embers.api.tile.IOrderSource;
import teamroots.embers.api.tile.OrderStack;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.TileEntityItemPipe;
import teamroots.embers.tileentity.TileEntityItemPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityItemExtractor
extends TileEntityItemPipeBase
implements IOrderDestination {
    Random random = new Random();
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.VALUES.length];
    IItemHandler[] sideHandlers;
    boolean syncConnections;
    boolean active;
    List<OrderStack> orders = new ArrayList<OrderStack>();

    @Override
    protected void initInventory() {
        super.initInventory();
        this.sideHandlers = new IItemHandler[EnumFacing.VALUES.length];
        for (final EnumFacing facing : EnumFacing.VALUES) {
            this.sideHandlers[facing.getIndex()] = new IItemHandler(){

                public int getSlots() {
                    return TileEntityItemExtractor.this.inventory.getSlots();
                }

                @Nonnull
                public ItemStack getStackInSlot(int slot) {
                    return TileEntityItemExtractor.this.inventory.getStackInSlot(slot);
                }

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (TileEntityItemExtractor.this.active) {
                        return stack;
                    }
                    if (!simulate) {
                        TileEntityItemExtractor.this.setFrom(facing, true);
                    }
                    return TileEntityItemExtractor.this.inventory.insertItem(slot, stack, simulate);
                }

                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return TileEntityItemExtractor.this.inventory.extractItem(slot, amount, simulate);
                }

                public int getSlotLimit(int slot) {
                    return TileEntityItemExtractor.this.inventory.getSlotLimit(slot);
                }
            };
        }
    }

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setInternalConnection(facing, this.getConnection(world, this.getPos().offset(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeConnections(tag);
        NBTTagList tagOrders = new NBTTagList();
        for (OrderStack order : this.orders) {
            tagOrders.appendTag((NBTBase)order.writeToNBT(new NBTTagCompound()));
        }
        tag.setTag("orders", (NBTBase)tagOrders);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.setInteger("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.setInteger("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.setInteger("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.setInteger("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.setInteger("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.setInteger("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.getInteger("up")));
        }
        if (tag.hasKey("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.getInteger("down")));
        }
        if (tag.hasKey("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.getInteger("north")));
        }
        if (tag.hasKey("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.getInteger("south")));
        }
        if (tag.hasKey("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.getInteger("west")));
        }
        if (tag.hasKey("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.getInteger("east")));
        }
        if (tag.hasKey("orders")) {
            NBTTagList tagOrders = tag.getTagList("orders", 10);
            this.orders.clear();
            for (NBTBase tagOrder : tagOrders) {
                this.orders.add(new OrderStack((NBTTagCompound)tagOrder));
            }
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.getUpdateTag();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    @Override
    int getCapacity() {
        return 4;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.inventory;
            }
            return (T)this.sideHandlers[facing.getIndex()];
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.getIndex()] != null ? this.connections[facing.getIndex()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.getIndex()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.getTileEntity(pos);
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof TileEntityItemExtractor) {
            return EnumPipeConnection.NONE;
        }
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(side.getOpposite());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.getOpposite())) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityItemExtractor.reverseForce(connection));
        TileEntity tile = this.world.getTileEntity(this.pos.offset(face));
        if (tile instanceof TileEntityItemPipe) {
            ((TileEntityItemPipe)tile).updateNeighbors((IBlockAccess)this.world);
        }
        if (tile instanceof TileEntityItemExtractor) {
            ((TileEntityItemExtractor)tile).updateNeighbors((IBlockAccess)this.world);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    @Override
    public void order(TileEntity source, IFilter filter, int orderSize) {
        OrderStack order = this.getOrder(source);
        if (order == null) {
            this.orders.add(new OrderStack(source.getPos(), filter, orderSize));
        } else if (Objects.equals(order.getFilter(), filter)) {
            order.increment(orderSize);
        } else {
            order.reset(filter, orderSize);
        }
    }

    @Override
    public void resetOrder(TileEntity source) {
        this.orders.removeIf(order -> order.getPos().equals((Object)source.getPos()));
    }

    public OrderStack getOrder(TileEntity source) {
        for (OrderStack order : this.orders) {
            if (!order.getPos().equals((Object)source.getPos())) continue;
            return order;
        }
        return null;
    }

    private void cleanupOrders() {
        this.orders.removeIf(this::isOrderInvalid);
    }

    private boolean isOrderInvalid(OrderStack order) {
        return order.getSize() <= 0 || order.getSource(this.world) == null;
    }

    @Override
    public void update() {
        if (this.world.isRemote && this.clogged) {
            Misc.spawnClogParticles(this.world, this.pos, 1, 0.25f);
        }
        if (!this.world.isRemote) {
            IOrderSource destination;
            this.cleanupOrders();
            this.active = this.getWorld().isBlockPowered(this.getPos());
            OrderStack currentOrder = this.orders.isEmpty() ? null : this.orders.get(0);
            IFilter filter = FilterUtil.FILTER_ANY;
            if (this.active) {
                currentOrder = null;
            } else if (currentOrder != null) {
                filter = currentOrder.getFilter();
            }
            IItemHandler invDest = null;
            if (currentOrder != null && (destination = currentOrder.getSource(this.world)) != null) {
                invDest = destination.getItemHandler();
            }
            for (EnumFacing facing : EnumFacing.VALUES) {
                TileEntity tile;
                if (!this.isConnected(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null || tile instanceof TileEntityItemPipeBase || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.getOpposite())) continue;
                if (this.active || currentOrder != null && currentOrder.getSize() > 0) {
                    ItemStack extracted;
                    IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.getOpposite());
                    int slot = -1;
                    for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                        ItemStack extracted2 = handler.extractItem(j, 1, true);
                        if (extracted2.isEmpty() || !filter.acceptsItem(extracted2, invDest)) continue;
                        slot = j;
                    }
                    if (slot != -1 && this.inventory.insertItem(0, extracted = handler.extractItem(slot, 1, true), true).isEmpty()) {
                        handler.extractItem(slot, 1, false);
                        this.inventory.insertItem(0, extracted, false);
                        if (currentOrder != null) {
                            currentOrder.deplete(extracted.getCount());
                        }
                    }
                    this.setFrom(facing, true);
                    continue;
                }
                this.setFrom(facing, false);
            }
        }
        super.update();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

