/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockInfernoForge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityInfernoForgeOpening;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityInfernoForge
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController {
    public static double EMBER_COST = ConfigMachine.INFERNO_FORGE.emberCost;
    public static int MAX_LEVEL = ConfigMachine.INFERNO_FORGE.maxLevel;
    public static double MAX_CRYSTAL_VALUE = ConfigMachine.INFERNO_FORGE.maxCrystalValue;
    public static double CHANCE_MIDPOINT = ConfigMachine.INFERNO_FORGE.chanceMidpoint;
    public static int PROCESS_TIME = ConfigMachine.INFERNO_FORGE.processTime;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    Random random = new Random();
    int progress = 0;
    int heat = 0;
    int ticksExisted = 0;
    double emberValue = 0.0;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityInfernoForge() {
        this.capability.setEmberCapacity(ConfigMachine.INFERNO_FORGE.capacity);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        tag.setInteger("heat", this.heat);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
        if (tag.hasKey("heat")) {
            this.heat = tag.getInteger("heat");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        ((BlockInfernoForge)state.getBlock()).cleanEdges(world, pos);
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        ++this.ticksExisted;
        if (this.progress <= 0) {
            return;
        }
        boolean cancel = UpgradeUtil.doWork(this, upgrades);
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, upgrades);
        if (cancel || this.capability.getEmber() < emberCost) {
            this.progress = 0;
            this.markDirty();
            return;
        }
        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
        this.capability.removeAmount(emberCost, true);
        --this.progress;
        if (this.getWorld().isRemote) {
            if (this.random.nextInt(10) == 0) {
                if (this.random.nextInt(3) == 0) {
                    ParticleUtil.spawnParticleSpark(this.world, (float)this.getPos().getX() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.75f, (float)this.getPos().getZ() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                }
                if (this.random.nextInt(3) == 0) {
                    ParticleUtil.spawnParticleSpark(this.world, (float)this.getPos().getX() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.75f, (float)this.getPos().getZ() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                }
                if (this.random.nextInt(3) == 0) {
                    ParticleUtil.spawnParticleSpark(this.world, (float)this.getPos().getX() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.75f, (float)this.getPos().getZ() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                }
                if (this.random.nextInt(3) == 0) {
                    ParticleUtil.spawnParticleSpark(this.world, (float)this.getPos().getX() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.75f, (float)this.getPos().getZ() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                }
            }
            ParticleUtil.spawnParticleSmoke(this.getWorld(), (float)this.getPos().getX() - 0.3f, (float)this.getPos().getY() + 1.85f, (float)this.getPos().getZ() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
            ParticleUtil.spawnParticleSmoke(this.getWorld(), (float)this.getPos().getX() + 1.3f, (float)this.getPos().getY() + 1.85f, (float)this.getPos().getZ() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
            ParticleUtil.spawnParticleSmoke(this.getWorld(), (float)this.getPos().getX() + 1.3f, (float)this.getPos().getY() + 1.85f, (float)this.getPos().getZ() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
            ParticleUtil.spawnParticleSmoke(this.getWorld(), (float)this.getPos().getX() - 0.3f, (float)this.getPos().getY() + 1.85f, (float)this.getPos().getZ() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
        }
        List<EntityItem> items = this.getValidItems();
        for (EntityItem e : items) {
            e.setPickupDelay(20);
        }
        if (this.progress != 0 || this.world.isRemote) {
            this.markDirty();
            return;
        }
        if (items.isEmpty()) {
            this.progress = 0;
            this.markDirty();
            return;
        }
        boolean forgeSuccess = false;
        TileEntityInfernoForgeOpening opening = this.getOpening();
        if (opening != null) {
            opening.open();
        }
        if (this.emberValue > 0.0) {
            for (EntityItem item : items) {
                if (!ItemModUtil.hasHeat(item.getItem())) {
                    this.world.removeEntity((Entity)item);
                    item.setDead();
                    continue;
                }
                if (!(this.emberValue <= MAX_CRYSTAL_VALUE) || !(Misc.random.nextDouble() < UpgradeUtil.getOtherParameter((TileEntity)this, "reforge_chance", Math.atan(this.emberValue / CHANCE_MIDPOINT) / 1.5707963267948966, upgrades))) continue;
                ItemStack stack = item.getItem();
                ItemModUtil.setHeat(stack, 0.0f);
                ItemModUtil.setLevel(stack, ItemModUtil.getLevel(stack) + 1);
                item.setItem(stack);
                this.progress = 0;
                forgeSuccess = true;
            }
        }
        if (!this.world.isRemote) {
            this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.5, (double)this.getPos().getZ() + 0.5, forgeSuccess ? SoundManager.INFERNO_FORGE_SUCCESS : SoundManager.INFERNO_FORGE_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            Color flameColor = new Color(255, 64, 16);
            if (!forgeSuccess) {
                flameColor = new Color(0, 0, 0);
            }
            if (this.emberValue > MAX_CRYSTAL_VALUE) {
                flameColor = new Color(16, 64, 255);
            }
            Color sparkColor = new Color(255, 64, 16);
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.5, (double)this.getPos().getZ() + 0.5, flameColor, sparkColor));
        }
        this.markDirty();
    }

    private TileEntityInfernoForgeOpening getOpening() {
        TileEntity tile = this.world.getTileEntity(this.pos.up());
        return tile instanceof TileEntityInfernoForgeOpening ? (TileEntityInfernoForgeOpening)tile : null;
    }

    public void updateProgress() {
        if (this.progress != 0) {
            return;
        }
        List<EntityItem> items = this.getValidItems();
        if (!items.isEmpty()) {
            this.progress = PROCESS_TIME;
            this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, SoundManager.INFERNO_FORGE_START, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.markDirty();
        }
    }

    private List<EntityItem> getValidItems() {
        List items = this.world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB((double)this.getPos().getX(), (double)this.getPos().getY() + 0.25, (double)this.getPos().getZ(), (double)(this.getPos().getX() + 1), (double)(this.getPos().getY() + 1), (double)(this.getPos().getZ() + 1)));
        ItemStack pickedItem = ItemStack.EMPTY;
        this.emberValue = 0.0;
        for (EntityItem item : items) {
            ItemStack stack = item.getItem();
            if (ItemModUtil.hasHeat(stack)) {
                if (pickedItem.isEmpty() && ItemModUtil.getLevel(stack) < MAX_LEVEL && ItemModUtil.getHeat(stack) >= ItemModUtil.getMaxHeat(stack)) {
                    pickedItem = stack;
                    continue;
                }
                return Lists.newArrayList();
            }
            if (EmbersAPI.getEmberValue(stack) > 0.0) {
                this.emberValue += EmbersAPI.getEmberValue(stack) * (double)stack.getCount();
                continue;
            }
            return Lists.newArrayList();
        }
        if (!pickedItem.isEmpty() && this.emberValue > 0.0) {
            return items;
        }
        return Lists.newArrayList();
    }

    @Override
    public void playSound(int id) {
        if (id == 1) {
            Embers.proxy.playMachineSound(this, 1, SoundManager.INFERNO_FORGE_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.progress > 0;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

