/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.block.BlockFluidTransfer;
import teamroots.embers.tileentity.TileEntityFluidPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityFluidTransfer
extends TileEntityFluidPipeBase {
    public static final int PRIORITY_TRANSFER = -10;
    public FluidStack filterFluid = null;
    Random random = new Random();
    boolean syncFilter;
    IFluidHandler outputSide;

    @Override
    protected void initFluidTank() {
        this.tank = new FluidTank(this.getCapacity()){

            protected void onContentsChanged() {
                TileEntityFluidTransfer.this.markDirty();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (TileEntityFluidTransfer.this.filterFluid != null) {
                    if (resource != null && (TileEntityFluidTransfer.this.filterFluid.tag != null ? resource.isFluidEqual(TileEntityFluidTransfer.this.filterFluid) : resource.getFluid() == TileEntityFluidTransfer.this.filterFluid.getFluid())) {
                        return super.fill(resource, doFill);
                    }
                    return 0;
                }
                return super.fill(resource, doFill);
            }
        };
        this.outputSide = Misc.makeRestrictedFluidHandler((IFluidHandler)this.tank, false, true);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeFilter(tag);
        return tag;
    }

    private void writeFilter(NBTTagCompound tag) {
        if (this.filterFluid != null) {
            tag.setTag("filter", (NBTBase)this.filterFluid.writeToNBT(new NBTTagCompound()));
        } else {
            tag.setString("filter", "empty");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("filter")) {
            this.filterFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.getCompoundTag("filter"));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.getUpdateTag();
        if (this.syncFilter) {
            this.writeFilter(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncFilter || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncFilter = false;
    }

    @Override
    int getCapacity() {
        return 250;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing == null || facing.getAxis() == this.getFacing().getAxis();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            EnumFacing transferFacing = this.getFacing();
            if (facing == transferFacing) {
                return (T)this.outputSide;
            }
            if (facing == null || facing.getAxis() == transferFacing.getAxis()) {
                return (T)this.tank;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getFacing() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        return (EnumFacing)state.getValue((IProperty)BlockFluidTransfer.facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!world.isRemote) {
            if (FluidUtil.getFluidHandler((ItemStack)heldItem) != null) {
                this.filterFluid = FluidUtil.getFluidContained((ItemStack)heldItem);
                world.setBlockState(pos, state.withProperty((IProperty)BlockFluidTransfer.filter, (Comparable)Boolean.valueOf(true)), 10);
            } else {
                this.filterFluid = null;
                world.setBlockState(pos, state.withProperty((IProperty)BlockFluidTransfer.filter, (Comparable)Boolean.valueOf(false)), 10);
            }
            this.syncFilter = true;
            this.markDirty();
            return true;
        }
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.getBlock() != newSate.getBlock();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    @Override
    public void update() {
        if (this.world.isRemote && this.clogged && this.isAnySideUnclogged()) {
            Misc.spawnClogParticles(this.world, this.pos, 2, 0.7f);
        }
        super.update();
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return -10;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getFacing().getAxis() == facing.getAxis();
    }

    @Override
    protected boolean isFrom(EnumFacing facing) {
        return facing == this.getFacing().getOpposite();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (this.getFacing().getAxis() == facing.getAxis()) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }
}

