/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.IFluidPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityFluidPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IFluidPipeConnectable,
IFluidPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    public static final int MAX_PUSH = 250;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.VALUES.length];
    boolean clogged = false;
    public FluidTank tank;
    EnumFacing lastTransfer;
    boolean syncTank;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityFluidPipeBase() {
        this.initFluidTank();
    }

    protected void initFluidTank() {
        this.tank = new FluidTank(this.getCapacity()){

            protected void onContentsChanged() {
                TileEntityFluidPipeBase.this.markDirty();
            }
        };
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.getPos(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.getIndex()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.getIndex()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.world.getTileEntity(this.pos.offset(facing))) instanceof TileEntityFluidPipeBase) || ((TileEntityFluidPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.world.isRemote) {
            ++this.ticksExisted;
            boolean fluidMoved = false;
            FluidStack passStack = this.tank.drain(250, false);
            if (passStack != null) {
                IFluidHandler handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                IFluidHandler[] fluidHandlers = new IFluidHandler[EnumFacing.VALUES.length];
                for (EnumFacing facing : EnumFacing.VALUES) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite())) continue;
                    handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite());
                    int priority = 0;
                    if (tile instanceof IFluidPipePriority) {
                        priority = ((IFluidPipePriority)tile).getPriority(facing.getOpposite());
                    }
                    if (this.isFrom(facing.getOpposite())) {
                        priority -= 5;
                    }
                    possibleDirections.put(priority, facing);
                    fluidHandlers[facing.getIndex()] = handler;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = fluidHandlers[facing.getIndex()];
                        fluidMoved = this.pushStack(passStack, facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.markDirty();
                        }
                        if (!fluidMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!fluidMoved) continue;
                    break;
                }
            }
            if (this.tank.getFluidAmount() <= 0) {
                if (this.lastTransfer != null && !fluidMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.markDirty();
                }
                fluidMoved = true;
                this.resetFrom();
            }
            if (this.clogged == fluidMoved) {
                this.clogged = !fluidMoved;
                this.syncCloggedFlag = true;
                this.markDirty();
            }
        } else if (Embers.proxy.isPlayerWearingGoggles() && this.lastTransfer != null) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.getXOffset() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.getYOffset() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.getZOffset() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.pos.getX() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getXOffset() * dist;
                float y = (float)this.pos.getY() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getYOffset() * dist;
                float z = (float)this.pos.getZ() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getZOffset() * dist;
                float r = this.clogged ? 255.0f : 16.0f;
                float g = this.clogged ? 16.0f : 255.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.world, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(FluidStack passStack, EnumFacing facing, IFluidHandler handler) {
        int added = handler.fill(passStack, false);
        if (added > 0) {
            handler.fill(passStack, true);
            this.tank.drain(added, true);
            passStack.amount -= added;
            return passStack.amount <= 0;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncTank = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncTank || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncTank) {
            this.writeTank(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeTank(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.VALUES) {
            tag.setBoolean("from" + facing.getIndex(), this.from[facing.getIndex()]);
        }
        tag.setInteger("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.setBoolean("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.setInteger("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writeTank(NBTTagCompound tag) {
        tag.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("clogged")) {
            this.clogged = tag.getBoolean("clogged");
        }
        if (tag.hasKey("tank")) {
            this.tank.readFromNBT(tag.getCompoundTag("tank"));
        }
        if (tag.hasKey("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.getInteger("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!tag.hasKey("from" + facing.getIndex())) continue;
            this.from[facing.getIndex()] = tag.getBoolean("from" + facing.getIndex());
        }
        if (tag.hasKey("lastRobin")) {
            this.lastRobin = tag.getInteger("lastRobin");
        }
    }
}

