/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.tileentity.TileEntityFluidExtractor;
import teamroots.embers.tileentity.TileEntityFluidPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;

public class TileEntityFluidExtractorRenderer
extends TileEntitySpecialRenderer<TileEntityFluidExtractor> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/pipe_tex.png");

    public void render(TileEntityFluidExtractor tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
            for (EnumFacing facing : EnumFacing.VALUES) {
                if (this.shouldRenderPipe(tile, facing)) {
                    PipeRenderUtil.addPipe(buffer, x, y, z, facing);
                }
                if (!this.shouldRenderLip(tile, facing)) continue;
                PipeRenderUtil.addPipeLip(buffer, x, y, z, facing);
            }
            tess.draw();
        }
    }

    private boolean shouldRenderLip(TileEntityFluidPipeBase pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    private boolean shouldRenderPipe(TileEntityFluidPipeBase pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.PIPE || this.shouldRenderLip(pipe, facing);
    }
}

