/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.EventManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageExplosionCharmFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityExplosionPedestal
extends TileEntity
implements ITileEntityBase,
ITickable,
IExtraCapabilityInformation {
    Random random = new Random();
    int active = 0;

    public boolean isActive() {
        return this.active > 0;
    }

    public void setActive(int time) {
        this.active = time;
    }

    public void absorb(Explosion explosion) {
        Vec3d explosionPos = explosion.getPosition();
        this.setActive(20);
        if (!this.world.isRemote) {
            this.world.playSound(null, explosionPos.x, explosionPos.y, explosionPos.z, SoundManager.EXPLOSION_CHARM_ABSORB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageExplosionCharmFX(explosionPos.x, explosionPos.y, explosionPos.z, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5));
        }
        this.markDirty();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("active", this.active);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.active = tag.getInteger("active");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        --this.active;
        if (!this.world.isRemote) {
            EventManager.putExplosionCharm(this.world, this.pos);
        }
        if (this.world.isRemote && this.isActive()) {
            for (int i = 0; i < 4; ++i) {
                float dist = this.random.nextFloat() * ((float)this.active * 1.2f) / 20.0f;
                float xOffset = this.random.nextBoolean() ? 1.0f : -1.0f;
                float zOffset = 0.0f;
                if (this.random.nextBoolean()) {
                    float h = xOffset;
                    xOffset = zOffset;
                    zOffset = h;
                }
                float size = (float)MathHelper.clampedLerp((double)6.0, (double)2.0, (double)(dist / 0.8f));
                int lifetime = (int)(this.random.nextDouble() * MathHelper.clampedLerp((double)20.0, (double)10.0, (double)((double)dist / 20.0)));
                float speed = -1.0f / (float)lifetime;
                ParticleUtil.spawnParticleGlow(this.getWorld(), (float)this.pos.getX() + 0.5f + (xOffset *= dist), (float)this.pos.getY() + 1.0f, (float)this.pos.getZ() + 0.5f + (zOffset *= dist), xOffset * speed, (this.random.nextFloat() - 0.5f) * 2.0f * 0.04f, zOffset * speed, 255.0f, 64.0f, 16.0f, size, lifetime);
            }
        }
    }
}

