/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberPulser;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityEmitter
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public static final double TRANSFER_RATE = ConfigMachine.EMITTER.transfer_rate;
    public static final double PULL_RATE = ConfigMachine.EMITTER.pull_rate;
    public static final double EMBER_CAPACITY = ConfigMachine.EMITTER.capacity;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityEmitter.this.markDirty();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityEmitter() {
        this.capability.setEmberCapacity(EMBER_CAPACITY);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.down = this.getConnection(world, this.getPos().down(), EnumFacing.DOWN);
        this.up = this.getConnection(world, this.getPos().up(), EnumFacing.UP);
        this.north = this.getConnection(world, this.getPos().north(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.getPos().south(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.getPos().west(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.getPos().east(), EnumFacing.EAST);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("up", this.up.ordinal());
        tag.setInteger("down", this.down.ordinal());
        tag.setInteger("north", this.north.ordinal());
        tag.setInteger("south", this.south.ordinal());
        tag.setInteger("west", this.west.ordinal());
        tag.setInteger("east", this.east.ordinal());
        if (this.target != null) {
            tag.setInteger("targetX", this.target.getX());
            tag.setInteger("targetY", this.target.getY());
            tag.setInteger("targetZ", this.target.getZ());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.up = TileEntityEmitter.connectionFromInt(tag.getInteger("up"));
        this.down = TileEntityEmitter.connectionFromInt(tag.getInteger("down"));
        this.north = TileEntityEmitter.connectionFromInt(tag.getInteger("north"));
        this.south = TileEntityEmitter.connectionFromInt(tag.getInteger("south"));
        this.west = TileEntityEmitter.connectionFromInt(tag.getInteger("west"));
        this.east = TileEntityEmitter.connectionFromInt(tag.getInteger("east"));
        if (tag.hasKey("targetX")) {
            this.target = new BlockPos(tag.getInteger("targetX"), tag.getInteger("targetY"), tag.getInteger("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Misc.isValidLever(world, pos, side) ? EnumConnection.LEVER : EnumConnection.NONE;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        TileEntity targetTile;
        IEmberCapability cap;
        ++this.ticksExisted;
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockEmberPulser.facing);
        TileEntity attachedTile = this.getWorld().getTileEntity(this.getPos().offset(facing.getOpposite()));
        if (this.ticksExisted % 5L == 0L && attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(PULL_RATE, true);
            this.capability.addAmount(removed, true);
        }
        if ((this.ticksExisted + (long)this.offset) % 20L == 0L && this.getWorld().isBlockPowered(this.getPos()) && this.target != null && !this.getWorld().isRemote && this.capability.getEmber() > PULL_RATE && (targetTile = this.getWorld().getTileEntity(this.target)) instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)targetTile).isFull()) {
            EntityEmberPacket packet = new EntityEmberPacket(this.getWorld());
            Vec3d velocity = this.getBurstVelocity(facing);
            packet.initCustom(this.getPos(), this.target, velocity.x, velocity.y, velocity.z, Math.min(TRANSFER_RATE, this.capability.getEmber()));
            this.capability.removeAmount(Math.min(TRANSFER_RATE, this.capability.getEmber()), true);
            this.getWorld().spawnEntity((Entity)packet);
            this.getWorld().playSound(null, this.pos, SoundManager.EMBER_EMIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private Vec3d getBurstVelocity(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3d(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3d(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3d(0.5, -0.01, 0.0);
            }
        }
        return Vec3d.ZERO;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        this.target = pos;
        this.markDirty();
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

