/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Explosion;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.entity.EntityEmberProjectile;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IEmberPipeConnectable;
import teamroots.embers.tileentity.IEmberPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityEmberPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPipeConnectable,
IEmberPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.VALUES.length];
    boolean clogged = false;
    double packet;
    EnumFacing lastTransfer;
    boolean syncPacket;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityEmberPipeBase() {
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.getPos(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.getIndex()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.getIndex()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.world.getTileEntity(this.pos.offset(facing))) instanceof TileEntityEmberPipeBase) || ((TileEntityEmberPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.world.isRemote) {
            ++this.ticksExisted;
            boolean packetMoved = false;
            if (this.packet > 0.0) {
                Object handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                Object[] emberCapabilities = new Object[EnumFacing.VALUES.length];
                for (EnumFacing facing : EnumFacing.VALUES) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null) continue;
                    handler = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.getOpposite());
                    int priority = 0;
                    if (tile instanceof IEmberPipePriority) {
                        priority = ((IEmberPipePriority)tile).getPriority(facing.getOpposite());
                    }
                    if (handler != null && handler.acceptsVolatile()) {
                        possibleDirections.put(priority, facing);
                        emberCapabilities[facing.getIndex()] = handler;
                        continue;
                    }
                    if (!(tile instanceof TileEntityEmberPipeBase)) continue;
                    possibleDirections.put(priority, facing);
                    emberCapabilities[facing.getIndex()] = tile;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = emberCapabilities[facing.getIndex()];
                        packetMoved = this.pushStack(facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.markDirty();
                        }
                        if (!packetMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!packetMoved) continue;
                    break;
                }
            }
            if (this.packet <= 0.0) {
                if (this.lastTransfer != null && !packetMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.markDirty();
                }
                packetMoved = true;
                this.resetFrom();
            }
            if (this.clogged == packetMoved) {
                this.clogged = !packetMoved;
                this.syncCloggedFlag = true;
                this.markDirty();
            }
            if (this.clogged && this.packet > 1.0) {
                this.packet = Math.floor(this.packet * 0.7);
                this.syncPacket = true;
                this.markDirty();
            }
        } else if (this.lastTransfer != null && this.isConnected(this.lastTransfer)) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.getXOffset() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.getYOffset() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.getZOffset() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.pos.getX() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getXOffset() * dist;
                float y = (float)this.pos.getY() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getYOffset() * dist;
                float z = (float)this.pos.getZ() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getZOffset() * dist;
                float r = 255.0f;
                float g = 64.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.world, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(EnumFacing facing, Object handler) {
        IEmberCapability emberCapability;
        double added;
        if (handler instanceof IEmberCapability && (added = (emberCapability = (IEmberCapability)handler).addAmount(this.packet, true)) > 0.0) {
            this.packet = 0.0;
            return true;
        }
        if (handler instanceof TileEntityEmberPipeBase) {
            TileEntityEmberPipeBase pipe = (TileEntityEmberPipeBase)handler;
            if (pipe.packet <= 0.0) {
                pipe.packet = this.packet;
                pipe.setFrom(facing.getOpposite(), true);
                this.packet = 0.0;
                return true;
            }
            boolean isColliding = true;
            int ends = 0;
            for (EnumFacing checkFacing : EnumFacing.VALUES) {
                if (!pipe.isConnected(checkFacing)) continue;
                ++ends;
                if (pipe.isFrom(checkFacing) || checkFacing == facing.getOpposite()) continue;
                isColliding = false;
                break;
            }
            if (isColliding && ends > 1) {
                double posX = (double)this.pos.getX() + 0.5;
                double posY = (double)this.pos.getY() + 0.5;
                double posZ = (double)this.pos.getZ() + 0.5;
                this.world.playSound(null, this.pos, SoundManager.MINI_BOILER_RUPTURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                Explosion explosion = this.world.newExplosion(null, posX, posY, posZ, 3.0f, true, false);
                this.world.setBlockToAir(this.pos);
                EffectDamage effect = new EffectDamage(4.0f, preset -> DamageSource.causeExplosionDamage((Explosion)explosion), 10, 0.0);
                for (int i = 0; i < 12; ++i) {
                    EntityEmberProjectile proj = new EntityEmberProjectile(this.world);
                    proj.initCustom(posX, posY, posZ, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 10.0, null);
                    proj.setLifetime(20 + this.random.nextInt(40));
                    proj.setEffect(effect);
                    this.world.spawnEntity((Entity)proj);
                }
            }
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncPacket = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncPacket || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncPacket) {
            this.writePacket(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writePacket(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.VALUES) {
            tag.setBoolean("from" + facing.getIndex(), this.from[facing.getIndex()]);
        }
        tag.setInteger("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.setBoolean("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.setInteger("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writePacket(NBTTagCompound tag) {
        tag.setDouble("packet", this.packet);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("clogged")) {
            this.clogged = tag.getBoolean("clogged");
        }
        if (tag.hasKey("packet")) {
            this.packet = tag.getDouble("packet");
        }
        if (tag.hasKey("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.getInteger("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!tag.hasKey("from" + facing.getIndex())) continue;
            this.from[facing.getIndex()] = tag.getBoolean("from" + facing.getIndex());
        }
        if (tag.hasKey("lastRobin")) {
            this.lastRobin = tag.getInteger("lastRobin");
        }
    }
}

