/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberEmitter;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityEmberFunnel
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketReceiver {
    public static final int TRANSFER_SPEED = ConfigMachine.EMBER_FUNNEL.transfer_speed;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityEmberFunnel.this.markDirty();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    long ticksExisted = 0L;

    public TileEntityEmberFunnel() {
        this.capability.setEmberCapacity(ConfigMachine.EMBER_FUNNEL.capacity);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean isFull() {
        return this.capability.getEmber() >= this.capability.getEmberCapacity();
    }

    @Override
    public boolean onReceive(EntityEmberPacket packet) {
        return true;
    }

    public void update() {
        IEmberCapability cap;
        ++this.ticksExisted;
        EnumFacing facing = (EnumFacing)this.world.getBlockState(this.pos).getValue((IProperty)BlockEmberEmitter.facing);
        BlockPos attachPos = this.pos.offset(facing.getOpposite());
        TileEntity attachTile = this.world.getTileEntity(attachPos);
        if (this.ticksExisted % 2L == 0L && attachTile != null && attachTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)) != null && cap.getEmber() < cap.getEmberCapacity() && this.capability.getEmber() > 0.0) {
            double added = cap.addAmount(Math.min((double)TRANSFER_SPEED, this.capability.getEmber()), true);
            double removed = this.capability.removeAmount(added, true);
            if (!this.world.isRemote) {
                attachTile.markDirty();
            }
        }
    }

    @Override
    public boolean activate(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float v, float v1, float v2) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

