/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityCopperCell
extends TileEntity
implements ITileEntityBase {
    public IEmberCapability capability = new DefaultEmberCapability();

    public TileEntityCopperCell() {
        this.capability.setEmberCapacity(ConfigMachine.COPPER_CELL.capacity);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        if (!(world.isRemote || player != null && player.capabilities.isCreativeMode)) {
            ItemStack toDrop = new ItemStack(BlockRegister.COPPER_CELL, 1);
            if (toDrop.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                IEmberCapability capability = (IEmberCapability)toDrop.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
                capability.setEmberCapacity(this.capability.getEmberCapacity());
                capability.setEmber(this.capability.getEmber());
            }
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, toDrop));
        }
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }
}

