/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.block.BlockClockworkAttenuator;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeClockworkAttenuator;
import teamroots.embers.util.Misc;

public class TileEntityClockworkAttenuator
extends TileEntity
implements ITickable,
ITileEntityBase {
    public UpgradeClockworkAttenuator upgrade;
    public boolean powered;
    public boolean lastPowered = false;
    public double activeSpeed = 0.0;
    public double inactiveSpeed = 1.0;
    public double angle;
    public double lastAngle;
    private Random random = new Random();
    public double[] validSpeeds = new double[]{0.0, 0.0625, 0.125, 0.25, 0.5, 1.0};

    public TileEntityClockworkAttenuator() {
        this.upgrade = new UpgradeClockworkAttenuator(this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setDouble("active_speed", this.activeSpeed);
        tag.setDouble("inactive_speed", this.inactiveSpeed);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.activeSpeed = tag.getDouble("active_speed");
        this.inactiveSpeed = tag.getDouble("inactive_speed");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        if (state.getBlock() instanceof BlockClockworkAttenuator) {
            return (EnumFacing)state.getValue((IProperty)BlockClockworkAttenuator.facing);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing().getOpposite() == facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().getOpposite() == facing) {
            return (T)this.upgrade;
        }
        return (T)super.getCapability(capability, facing);
    }

    public double getSpeed() {
        return this.powered ? this.activeSpeed : this.inactiveSpeed;
    }

    public double getNext(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b > current) || !(a <= current)) continue;
            return b;
        }
        return current;
    }

    public double getPrevious(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b >= current) || !(a < current)) continue;
            return a;
        }
        return current;
    }

    public void update() {
        this.lastPowered = this.powered;
        this.powered = this.world.isBlockPowered(this.pos);
        if (this.world.isRemote) {
            this.lastAngle = this.angle;
            this.angle += this.getSpeed();
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.powered) {
            this.activeSpeed = player.isSneaking() ? this.getPrevious(this.activeSpeed) : this.getNext(this.activeSpeed);
        } else {
            this.inactiveSpeed = player.isSneaking() ? this.getPrevious(this.inactiveSpeed) : this.getNext(this.inactiveSpeed);
        }
        this.markDirty();
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

