/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockEmberGauge;
import teamroots.embers.block.BlockItemGauge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCharger
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static double MAX_TRANSFER = ConfigMachine.CHARGER.maxTransfer;
    public static double MAX_CAPACITY = ConfigMachine.CHARGER.capacity;
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileEntityCharger.this.markDirty();
        }
    };
    Random random = new Random();
    boolean isWorking;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCharger() {
        this.capability.setEmberCapacity(MAX_CAPACITY);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (heldItem.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            player.setHeldItem(hand, this.inventory.insertItem(0, heldItem, false));
            this.markDirty();
            return true;
        }
        if (!stack.isEmpty() && heldItem.isEmpty()) {
            if (!this.getWorld().isRemote) {
                player.setHeldItem(hand, this.inventory.extractItem(0, stack.getCount(), false));
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public void update() {
        boolean cancel;
        this.turnRate = 1;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.VALUES);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        World world = this.getWorld();
        if (world.isRemote) {
            this.handleSound();
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        this.isWorking = false;
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && !(cancel = UpgradeUtil.doWork(this, upgrades))) {
            double emberAdded;
            IEmberCapability itemCapability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            double transferRate = UpgradeUtil.getTotalSpeedModifier(this, upgrades) * MAX_TRANSFER;
            if (transferRate > 0.0) {
                emberAdded = itemCapability.addAmount(Math.min(Math.abs(transferRate), this.capability.getEmber()), !world.isRemote);
                this.capability.removeAmount(emberAdded, !world.isRemote);
            } else {
                emberAdded = this.capability.addAmount(Math.min(Math.abs(transferRate), itemCapability.getEmber()), !world.isRemote);
                itemCapability.removeAmount(emberAdded, !world.isRemote);
            }
            if (emberAdded > 0.0) {
                this.isWorking = true;
            }
            this.markDirty();
            if (world.isRemote && this.isWorking && this.capability.getEmber() > 0.0) {
                int i = 0;
                while ((double)i < Math.ceil(this.capability.getEmber() / 500.0)) {
                    ParticleUtil.spawnParticleGlow(world, (float)this.getPos().getX() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.getPos().getY() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.getPos().getZ() + 0.25f + this.random.nextFloat() * 0.5f, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                    ++i;
                }
            }
        }
        this.angle += this.turnRate;
    }

    @Override
    public void playSound(int id) {
        if (id == 1) {
            Embers.proxy.playMachineSound(this, 1, SoundManager.COPPER_CHARGER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        ItemStack stack;
        if ("ember".equals(dialType) && (stack = this.inventory.getStackInSlot(0)).hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability itemCapability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            information.add(BlockItemGauge.formatItemStack(stack));
            information.add(BlockEmberGauge.formatEmber(itemCapability.getEmber(), itemCapability.getEmberCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ember_storage", (Object[])new Object[0])));
        }
    }
}

