/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockCatalyticPlug;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeCatalyticPlug;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCatalyticPlug
extends TileEntity
implements ITickable,
ITileEntityBase,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final int SOUND_OFF = 1;
    public static final int SOUND_ON = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    public static final int CAPACITY = ConfigMachine.CATALYTIC_PLUG.capacity;
    public int activeTicks = 0;
    public UpgradeCatalyticPlug upgrade;
    public FluidTank tank = new FluidTank(CAPACITY){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.getFluid((String)"alchemical_redstone");
        }
    };
    private Random random = new Random();
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCatalyticPlug() {
        this.upgrade = new UpgradeCatalyticPlug(this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.setTag("tank", (NBTBase)tankTag);
        tag.setInteger("active", this.activeTicks);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.tank.readFromNBT(tag.getCompoundTag("tank"));
        this.activeTicks = tag.getInteger("active");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        if (state.getBlock() instanceof BlockCatalyticPlug) {
            return (EnumFacing)state.getValue((IProperty)BlockCatalyticPlug.FACING);
        }
        return null;
    }

    public void setActive(int ticks) {
        this.activeTicks = Math.max(ticks, this.activeTicks);
        this.markDirty();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing() == facing;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFacing().getOpposite() == facing || facing == null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing() == facing) {
            return (T)this.upgrade;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.getFacing().getOpposite() == facing || facing == null)) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        --this.activeTicks;
        IBlockState state = this.world.getBlockState(this.pos);
        if (this.activeTicks > 0 && this.world.isRemote && state.getBlock() instanceof BlockCatalyticPlug) {
            EnumFacing[] planars;
            EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockCatalyticPlug.FACING);
            float yoffset = 0.4f;
            float wideoffset = 0.5f;
            Vec3d baseOffset = new Vec3d(0.5 - (double)((float)facing.getXOffset() * yoffset), 0.5 - (double)((float)facing.getYOffset() * yoffset), 0.5 - (double)((float)facing.getZOffset() * yoffset));
            switch (facing.getAxis()) {
                case X: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Y: {
                    planars = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Z: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST};
                    break;
                }
                default: {
                    planars = null;
                }
            }
            for (void var10_10 : planars) {
                IBlockState sideState = this.world.getBlockState(this.pos.offset((EnumFacing)var10_10));
                if (sideState.getBlockFaceShape((IBlockAccess)this.world, this.pos.offset((EnumFacing)var10_10), var10_10.getOpposite()) != BlockFaceShape.UNDEFINED) continue;
                float x = (float)this.getPos().getX() + (float)baseOffset.x + (float)var10_10.getXOffset() * wideoffset;
                float y = (float)this.getPos().getY() + (float)baseOffset.y + (float)var10_10.getYOffset() * wideoffset;
                float z = (float)this.getPos().getZ() + (float)baseOffset.z + (float)var10_10.getZOffset() * wideoffset;
                float motionx = (float)var10_10.getXOffset() * 0.03f - (float)facing.getXOffset() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                float motiony = (float)var10_10.getYOffset() * 0.03f - (float)facing.getYOffset() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                float motionz = (float)var10_10.getZOffset() * 0.03f - (float)facing.getZOffset() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                ParticleUtil.spawnParticleVapor(this.getWorld(), x, y, z, motionx, motiony, motionz, 255.0f, 16.0f, 16.0f, 1.0f, 1.0f, 2.0f, 24);
            }
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.pos.getX() + 0.5f;
        float soundY = (float)this.pos.getY() + 0.5f;
        float soundZ = (float)this.pos.getZ() + 0.5f;
        switch (id) {
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.CATALYTIC_PLUG_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.world.playSound((double)soundX, (double)soundY, (double)soundZ, SoundManager.CATALYTIC_PLUG_START, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.CATALYTIC_PLUG_LOOP_READY, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        if (id == 2) {
            this.world.playSound((double)((float)this.pos.getX() + 0.5f), (double)((float)this.pos.getY() + 0.5f), (double)((float)this.pos.getZ() + 0.5f), SoundManager.CATALYTIC_PLUG_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking && this.tank.getFluidAmount() > 0;
            }
            case 2: {
                return isWorking;
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking ? 1.0f : 0.0f;
            }
            case 2: {
                return isWorking ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(BlockFluidGauge.formatFluidStack(this.getFluidStack(), this.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.redstone", (Object[])new Object[0])));
        }
    }
}

