/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import teamroots.embers.EventManager;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.block.BlockBreaker;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityBreaker
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    Random random = new Random();
    WeakReference<FakePlayer> fakePlayer;

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public void onLoad() {
        if (!this.world.isRemote) {
            this.initFakePlayer();
        }
    }

    protected void initFakePlayer() {
        FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.world), (GameProfile)new GameProfile(new UUID(13L, 13L), "embers_breaker"));
        player.connection = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)player){

            public void sendPacket(Packet packetIn) {
            }
        };
        this.fakePlayer = new WeakReference<FakePlayer>(player);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        ++this.ticksExisted;
        IBlockState state = this.world.getBlockState(this.pos);
        if (this.ticksExisted % 20 == 0 && this.isActive() && state.getBlock() instanceof BlockBreaker && !this.world.isRemote) {
            EnumFacing facing = this.getFacing();
            this.mineBlock(this.pos.offset(facing));
        }
    }

    public boolean isActive() {
        return !this.getWorld().isBlockPowered(this.getPos());
    }

    protected void mineBlock(BlockPos breakPos) {
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        if (player == null) {
            return;
        }
        int exp = ForgeHooks.onBlockBreakEvent((World)this.world, (GameType)player.interactionManager.getGameType(), (EntityPlayerMP)player, (BlockPos)breakPos);
        if (exp != -1) {
            IBlockState state = this.world.getBlockState(breakPos);
            TileEntity tile = this.world.getTileEntity(breakPos);
            Block block = state.getBlock();
            NonNullList<ItemStack> drops = null;
            if (state.getBlockHardness(this.world, this.pos) < 0.0f || this.isBlacklisted(block) && !player.canUseCommandBlock()) {
                this.world.notifyBlockUpdate(breakPos, state, state, 3);
            } else {
                this.world.playEvent((EntityPlayer)player, 2001, breakPos, Block.getStateId((IBlockState)state));
                if (player.isCreative()) {
                    this.removeBlock(player, breakPos, false);
                } else {
                    boolean flag1 = this.removeBlock(player, breakPos, true);
                    if (flag1) {
                        EventManager.captureDrops(true);
                        state.getBlock().harvestBlock(this.world, (EntityPlayer)player, breakPos, state, tile, ItemStack.EMPTY);
                        drops = EventManager.captureDrops(false);
                    }
                }
            }
            if (drops != null) {
                this.collectDrops(drops);
            }
        }
    }

    private boolean isBlacklisted(Block block) {
        return block instanceof BlockCommandBlock || block instanceof BlockStructure;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        return (EnumFacing)state.getValue((IProperty)BlockBreaker.facing);
    }

    private void collectDrops(NonNullList<ItemStack> stacks) {
        EnumFacing facing = this.getFacing();
        BlockPos frontPos = this.getPos().offset(facing);
        BlockPos binPos = this.getPos().offset(facing.getOpposite());
        TileEntity bin = this.getWorld().getTileEntity(binPos);
        boolean capture = bin instanceof IBin;
        for (ItemStack stack : stacks) {
            if (capture) {
                ItemStack remainder = ((IBin)bin).getInventory().insertItem(0, stack, false);
                if (!remainder.isEmpty() && !this.getWorld().isRemote) {
                    EntityItem item = new EntityItem(this.getWorld(), (double)frontPos.getX() + 0.5, (double)((float)frontPos.getY() + 1.0625f), (double)frontPos.getZ() + 0.5, remainder);
                    this.getWorld().spawnEntity((Entity)item);
                }
                bin.markDirty();
                this.markDirty();
                continue;
            }
            EntityItem item = new EntityItem(this.getWorld(), (double)frontPos.getX() + 0.5, (double)((float)frontPos.getY() + 1.0625f), (double)frontPos.getZ() + 0.5, stack);
            this.getWorld().spawnEntity((Entity)item);
        }
    }

    private boolean removeBlock(FakePlayer player, BlockPos pos, boolean canHarvest) {
        IBlockState state = this.world.getBlockState(pos);
        boolean flag = state.getBlock().removedByPlayer(state, this.world, pos, (EntityPlayer)player, canHarvest);
        if (flag) {
            state.getBlock().onPlayerDestroy(this.world, pos, state);
        }
        return flag;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

