/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IHammerable;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockAutoHammer;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityAutoHammer
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
IExtraDialInformation {
    public static final double EMBER_COST = 40.0;
    public static final int PROCESS_TIME = 20;
    public IEmberCapability capability = new DefaultEmberCapability();
    int ticksExisted = 0;
    int progress = -1;
    Random random = new Random();
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityAutoHammer() {
        this.capability.setEmberCapacity(12000.0);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        this.progress = tag.getInteger("progress");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        IBlockState state = this.world.getBlockState(this.getPos());
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockAutoHammer.facing);
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, new EnumFacing[]{facing.getOpposite()});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        ++this.ticksExisted;
        double ember_cost = UpgradeUtil.getTotalEmberConsumption(this, 40.0, this.upgrades);
        TileEntity tile = this.world.getTileEntity(this.getPos().down().offset(facing));
        if (tile instanceof IHammerable) {
            boolean cancel;
            IHammerable hammerable = (IHammerable)tile;
            boolean redstoneEnabled = this.getWorld().isBlockPowered(this.getPos());
            if (hammerable.isValid() && redstoneEnabled && this.capability.getEmber() >= ember_cost && !(cancel = UpgradeUtil.doWork(this, this.upgrades)) && this.progress == -1 && this.ticksExisted % UpgradeUtil.getWorkTime(this, 20, this.upgrades) == 0) {
                this.progress = 10;
                this.markDirty();
            }
            if (this.progress > 0) {
                --this.progress;
                if (this.progress == 5 && this.capability.getEmber() >= ember_cost) {
                    UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, ember_cost), this.upgrades);
                    this.capability.removeAmount(ember_cost, true);
                    hammerable.onHit(this);
                }
                this.markDirty();
            }
        }
        if (this.progress == 0) {
            this.progress = -1;
            this.markDirty();
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 20.0, 0.075);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getMinimumPower() {
        return 10.0;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }
}

