/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.Misc;

public class TileEntityArchaicGeysir
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    int ticksExisted = 0;
    long charge = 0L;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().expand(4.0, 256.0, 4.0);
    }

    public TileEntityArchaicGeysir() {
        this.tank = new FluidTank(Integer.MAX_VALUE){

            public void onContentsChanged() {
                TileEntityArchaicGeysir.this.markDirty();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityArchaicGeysir.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return 0;
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(false);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setBlockToAir(pos.add(1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, -1));
        world.setBlockToAir(pos.add(1, 0, -1));
        world.setBlockToAir(pos.add(-1, 0, 1));
        world.setBlockToAir(pos.add(1, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, -1));
        world.setTileEntity(pos, null);
    }

    public void update() {
        ++this.ticksExisted;
        if (this.world.isRemote) {
            this.updateEscapeParticles();
        }
        this.lastEscapedTickServer = this.lastEscapedTickClient = this.world.getTotalWorldTime();
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(99, 100, 135);
        Random random = new Random();
        float force = 0.5f;
        for (int i = 0; i < 15; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f * force;
            float yOffset = 1.1f + 0.4f * force;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f * force;
            double angle = random.nextDouble() * 2.0 * Math.PI;
            float velocity = random.nextFloat() * 0.2f;
            float xVel = (float)Math.sin(angle) * (velocity *= force);
            float yVel = velocity * 5.0f;
            float zVel = (float)Math.cos(angle) * velocity;
            ParticleUtil.spawnParticleVapor(this.world, (float)this.pos.getX() + xOffset, (float)this.pos.getY() + yOffset, (float)this.pos.getZ() + zOffset, xVel, yVel, zVel, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 6.0f * force, 20.0f * force, 40);
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE((TileEntity)this);
    }
}

