/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityActivatorTop;
import teamroots.embers.util.Misc;

public class TileEntityActivatorBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
IExtraCapabilityInformation,
IExtraDialInformation {
    public static final int PROCESS_TIME = ConfigMachine.ACTIVATOR.process_time;
    Random random = new Random();
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityActivatorBottom.this.markDirty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmbersAPI.getEmberValue(stack) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(this.getWorld(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.HORIZONTALS);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            TileEntity tile = this.getWorld().getTileEntity(this.getPos().up());
            boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
            if (!cancel && tile instanceof TileEntityActivatorTop) {
                TileEntityActivatorTop top = (TileEntityActivatorTop)tile;
                ++this.progress;
                if (this.progress > UpgradeUtil.getWorkTime(this, PROCESS_TIME, this.upgrades)) {
                    ItemStack emberStack;
                    double emberValue;
                    double ember;
                    this.progress = 0;
                    int i = 0;
                    if (this.inventory != null && (ember = UpgradeUtil.getTotalEmberProduction(this, emberValue = EmbersAPI.getEmberValue(emberStack = this.inventory.getStackInSlot(i)), this.upgrades)) > 0.0 && top.capability.getEmber() + ember <= top.capability.getEmberCapacity()) {
                        if (!this.world.isRemote) {
                            this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.5, (double)this.getPos().getZ() + 0.5, SoundManager.ACTIVATOR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.getPos().getX() + 0.5f, (float)this.getPos().getY() + 1.5f, (float)this.getPos().getZ() + 0.5f));
                        }
                        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.PRODUCE, ember), this.upgrades);
                        top.capability.addAmount(ember, true);
                        this.inventory.extractItem(i, 1, false);
                        this.markDirty();
                        top.markDirty();
                    }
                }
                this.markDirty();
            }
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }
}

