/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.research.subtypes;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.util.Vec2i;

public class ResearchShowItem
extends ResearchBase {
    LinkedList<DisplayItem> displayItems = new LinkedList();

    public ResearchShowItem(String location, ItemStack icon, double x, double y) {
        super(location, icon, x, y);
    }

    public ResearchShowItem(String location, ItemStack icon, Vec2i pos) {
        this(location, icon, pos.x, pos.y);
    }

    public ResearchShowItem addItem(DisplayItem item) {
        this.displayItems.add(item);
        return this;
    }

    @Override
    public List<String> getLines(FontRenderer renderer, String s, int width) {
        List<String> lines = super.getLines(renderer, s, width);
        int offset = this.displayItems.size() * 24;
        for (int i = 0; i < offset; i += renderer.FONT_HEIGHT + 3) {
            lines.add(0, "");
        }
        return lines;
    }

    @Override
    public void renderPageContent(GuiCodex gui, int basePosX, int basePosY, FontRenderer fontRenderer) {
        int slotX;
        int slotY;
        int batchOff;
        ItemStack[] stacks;
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.getBackground());
        int textOffX = 3;
        int textOffY = 2;
        int y = 0;
        for (DisplayItem displayItem : this.displayItems) {
            stacks = displayItem.getStacks();
            batchOff = displayItem.sideText == null ? (152 - stacks.length * 24) / 2 : 0;
            slotY = basePosY - textOffY + 43 + y * 24;
            for (int x = 0; x < stacks.length; ++x) {
                slotX = basePosX - textOffX + batchOff + 20;
                gui.drawTexturedModalRect(slotX + x * 24, slotY, 192, 0, 24, 24);
            }
            ++y;
        }
        super.renderPageContent(gui, basePosX, basePosY, fontRenderer);
        y = 0;
        for (DisplayItem displayItem : this.displayItems) {
            stacks = displayItem.getStacks();
            batchOff = displayItem.sideText == null ? (152 - stacks.length * 24) / 2 : 0;
            slotY = basePosY - textOffY + 43 + y * 24;
            for (int x = 0; x < stacks.length; ++x) {
                slotX = basePosX - textOffX + batchOff + 20 + x * 24;
                gui.renderItemStackMinusTooltipAt(stacks[x], slotX + 4, slotY + 4);
            }
            if (displayItem.sideText != null) {
                List strings = fontRenderer.listFormattedStringToWidth(displayItem.getSideText(), 152 - stacks.length * 24);
                int textOff = strings.size() <= 1 ? (fontRenderer.FONT_HEIGHT + 3) / 2 : 0;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    GuiCodex.drawTextGlowing(fontRenderer, (String)strings.get(i), basePosX + 20 + stacks.length * 24, slotY + textOffY + textOff + i * (fontRenderer.FONT_HEIGHT + 3));
                }
            }
            ++y;
        }
    }

    public static class DisplayItem {
        public ItemStack[] stacks;
        public String sideText;

        public DisplayItem(ItemStack ... stacks) {
            this.stacks = stacks;
        }

        public DisplayItem(String sideText, ItemStack ... stacks) {
            this.stacks = stacks;
            this.sideText = sideText;
        }

        public ItemStack[] getStacks() {
            return this.stacks;
        }

        public String getSideText() {
            return I18n.format((String)("embers.research.image." + this.sideText), (Object[])new Object[0]);
        }
    }
}

