/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.register;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import teamroots.embers.fluid.FluidGas;
import teamroots.embers.fluid.FluidMoltenAluminum;
import teamroots.embers.fluid.FluidMoltenBronze;
import teamroots.embers.fluid.FluidMoltenCopper;
import teamroots.embers.fluid.FluidMoltenDawnstone;
import teamroots.embers.fluid.FluidMoltenElectrum;
import teamroots.embers.fluid.FluidMoltenGold;
import teamroots.embers.fluid.FluidMoltenIron;
import teamroots.embers.fluid.FluidMoltenLead;
import teamroots.embers.fluid.FluidMoltenMetal;
import teamroots.embers.fluid.FluidMoltenNickel;
import teamroots.embers.fluid.FluidMoltenSilver;
import teamroots.embers.fluid.FluidMoltenTin;
import teamroots.embers.fluid.FluidOilDwarven;
import teamroots.embers.fluid.FluidSteam;
import teamroots.embers.register.IRegistrable;

public class FluidRegister
implements IRegistrable<Fluid> {
    public static final FluidRegister INSTANCE = new FluidRegister();
    public static final Fluid FLUID_STEAM = new FluidSteam();
    public static final Fluid FLUID_CRUDE_OIL = new FluidMoltenMetal("oil_soul", "oil_soul");
    public static final Fluid FLUID_OIL = new FluidOilDwarven();
    public static final Fluid FLUID_GAS = new FluidGas();
    public static final Fluid FLUID_MOLTEN_IRON = new FluidMoltenIron();
    public static final Fluid FLUID_MOLTEN_GOLD = new FluidMoltenGold();
    public static final Fluid FLUID_MOLTEN_LEAD = new FluidMoltenLead();
    public static final Fluid FLUID_MOLTEN_COPPER = new FluidMoltenCopper();
    public static final Fluid FLUID_MOLTEN_SILVER = new FluidMoltenSilver();
    public static final Fluid FLUID_MOLTEN_DAWNSTONE = new FluidMoltenDawnstone();
    public static final Fluid FLUID_MOLTEN_TIN = new FluidMoltenTin();
    public static final Fluid FLUID_MOLTEN_ALUMINUM = new FluidMoltenAluminum();
    public static final Fluid FLUID_MOLTEN_NICKEL = new FluidMoltenNickel();
    public static final Fluid FLUID_MOLTEN_BRONZE = new FluidMoltenBronze();
    public static final Fluid FLUID_MOLTEN_ELECTRUM = new FluidMoltenElectrum();
    public static final Fluid FLUID_ALCHEMICAL_REDSTONE = new FluidMoltenMetal("alchemical_redstone", "alchemic_slurry");
    private static final List<Fluid> REGISTRY = new ArrayList<Fluid>(Arrays.asList(FLUID_STEAM, FLUID_CRUDE_OIL, FLUID_OIL, FLUID_GAS, FLUID_MOLTEN_IRON, FLUID_MOLTEN_GOLD, FLUID_MOLTEN_LEAD, FLUID_MOLTEN_COPPER, FLUID_MOLTEN_SILVER, FLUID_MOLTEN_DAWNSTONE, FLUID_MOLTEN_TIN, FLUID_MOLTEN_ALUMINUM, FLUID_MOLTEN_NICKEL, FLUID_MOLTEN_BRONZE, FLUID_MOLTEN_ELECTRUM, FLUID_ALCHEMICAL_REDSTONE));

    private FluidRegister() {
    }

    @Override
    public Collection<Fluid> load() {
        return REGISTRY;
    }

    @Override
    public void register() {
        for (Fluid f : INSTANCE.load()) {
            FluidRegistry.registerFluid((Fluid)f);
            FluidRegistry.addBucketForFluid((Fluid)f);
        }
    }

    @Override
    public void add(Fluid registrable) {
        REGISTRY.add(registrable);
    }
}

