/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import teamroots.embers.recipe.AnvilRepairFakeRecipe;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.IWrappableRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.Misc;

public class AnvilRepairRecipe
extends DawnstoneAnvilRecipe
implements IWrappableRecipe {
    @Override
    public boolean matches(ItemStack input1, ItemStack input2) {
        return !input1.isEmpty() && !input2.isEmpty() && input1.getItem().getIsRepairable(input1, input2) && !RecipeRegistry.isBlacklistedFromRepair(input1);
    }

    @Override
    public List<ItemStack> getResult(TileEntity tile, ItemStack input1, ItemStack input2) {
        ItemStack result = input1.copy();
        result.setItemDamage(Math.max(0, result.getItemDamage() - result.getMaxDamage()));
        return Lists.newArrayList((Object[])new ItemStack[]{result});
    }

    public List<DawnstoneAnvilRecipe> getWrappers() {
        ArrayList recipes = Lists.newArrayList();
        for (Item item : Item.REGISTRY) {
            ItemStack stack = item.getDefaultInstance();
            ItemStack repairStack = Misc.getRepairItem(stack);
            if (repairStack.isEmpty() || !item.getIsRepairable(stack, repairStack) || RecipeRegistry.isBlacklistedFromRepair(stack)) continue;
            recipes.add(new AnvilRepairFakeRecipe(stack));
        }
        return recipes;
    }
}

