/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.IFocusRecipe;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.util.IngredientSpecial;

public class AnvilAddModifierFakeRecipe
extends DawnstoneAnvilRecipe
implements IFocusRecipe {
    ItemStack modifier;

    public AnvilAddModifierFakeRecipe(ItemStack modifier) {
        super(new IngredientSpecial(stack -> ItemModUtil.getModifier(modifier).canApplyTo((ItemStack)stack)), Ingredient.fromStacks((ItemStack[])new ItemStack[]{modifier}), new ItemStack[0]);
        this.modifier = modifier;
    }

    @Override
    public List<ItemStack> getBottomInputs() {
        return super.getBottomInputs().stream().map(this::prepareInput).collect(Collectors.toList());
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.getBottomInputs().stream().map(this::prepareOutput).collect(Collectors.toList());
    }

    private ItemStack prepareInput(ItemStack stack) {
        ItemStack input = stack.copy();
        if (!ItemModUtil.hasHeat(input)) {
            ItemModUtil.addModifier(input, new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE));
        }
        ItemModUtil.setLevel(input, ItemModUtil.getLevel(input) + 1);
        return input;
    }

    private ItemStack prepareOutput(ItemStack stack) {
        ItemStack output = stack.copy();
        ItemModUtil.addModifier(output, this.modifier);
        return output;
    }

    @Override
    public List<ItemStack> getOutputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 2) {
            if (((ItemStack)focus.getValue()).isItemEqual(this.modifier)) {
                return this.getOutputs();
            }
            return Lists.newArrayList((Object[])new ItemStack[]{this.prepareOutput(this.prepareInput((ItemStack)focus.getValue()))});
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemStack> getInputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 0) {
            if (((ItemStack)focus.getValue()).isItemEqual(this.modifier)) {
                return this.getBottomInputs();
            }
            return Lists.newArrayList((Object[])new ItemStack[]{this.prepareInput((ItemStack)focus.getValue())});
        }
        if (slot == 1) {
            return Lists.newArrayList((Object[])new ItemStack[]{this.modifier});
        }
        return Lists.newArrayList();
    }
}

