/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import teamroots.embers.api.alchemy.AlchemyResult;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.util.IHasAspects;

public class AlchemyRecipe
implements IHasAspects {
    @Deprecated
    public int ironAspectMin = 0;
    @Deprecated
    public int dawnstoneAspectMin = 0;
    @Deprecated
    public int copperAspectMin = 0;
    @Deprecated
    public int silverAspectMin = 0;
    @Deprecated
    public int leadAspectMin = 0;
    @Deprecated
    public int ironAspectRange = 0;
    @Deprecated
    public int dawnstoneAspectRange = 0;
    @Deprecated
    public int copperAspectRange = 0;
    @Deprecated
    public int silverAspectRange = 0;
    @Deprecated
    public int leadAspectRange = 0;
    @Deprecated
    public List<ItemStack> inputs = new ArrayList<ItemStack>();
    @Deprecated
    public ItemStack centerInput = ItemStack.EMPTY;
    public Ingredient centerIngredient;
    public List<Ingredient> outsideIngredients;
    public AspectList.AspectRangeList aspectRange;
    public ItemStack result = ItemStack.EMPTY;
    Random random = new Random();

    public AlchemyRecipe(AspectList.AspectRangeList range, Ingredient center, List<Ingredient> outside, ItemStack result) {
        this.result = result;
        this.centerIngredient = center;
        this.outsideIngredients = outside;
        this.aspectRange = range;
    }

    @Deprecated
    public AlchemyRecipe(int ironMin, int ironMax, int dawnstoneMin, int dawnstoneMax, int copperMin, int copperMax, int silverMin, int silverMax, int leadMin, int leadMax, ItemStack center, ItemStack east, ItemStack west, ItemStack north, ItemStack south, ItemStack result) {
        this.aspectRange = new AspectList.AspectRangeList(AspectList.createStandard(ironMin, dawnstoneMin, copperMin, silverMin, leadMin), AspectList.createStandard(ironMax, dawnstoneMax, copperMax, silverMax, leadMax));
        this.centerIngredient = Ingredient.fromStacks((ItemStack[])new ItemStack[]{center});
        this.outsideIngredients = Lists.newArrayList((Object[])new Ingredient[]{Ingredient.fromStacks((ItemStack[])new ItemStack[]{east}), Ingredient.fromStacks((ItemStack[])new ItemStack[]{north}), Ingredient.fromStacks((ItemStack[])new ItemStack[]{west}), Ingredient.fromStacks((ItemStack[])new ItemStack[]{south})});
        this.result = result;
    }

    @Deprecated
    public int getIron(World world) {
        return this.aspectRange.getExact("iron", world);
    }

    @Deprecated
    public int getDawnstone(World world) {
        return this.aspectRange.getExact("dawnstone", world);
    }

    @Deprecated
    public int getCopper(World world) {
        return this.aspectRange.getExact("copper", world);
    }

    @Deprecated
    public int getSilver(World world) {
        return this.aspectRange.getExact("silver", world);
    }

    @Deprecated
    public int getLead(World world) {
        return this.aspectRange.getExact("lead", world);
    }

    @Override
    public AspectList.AspectRangeList getAspects() {
        return this.aspectRange;
    }

    public AlchemyResult matchAshes(AspectList list, World world) {
        return AlchemyResult.create(list, this.aspectRange, world);
    }

    public boolean matches(ItemStack center, List<ItemStack> test) {
        if (!this.centerIngredient.apply(center)) {
            return false;
        }
        if (center.getTagCompound() != null && Arrays.stream(this.centerIngredient.getMatchingStacks()).noneMatch(x -> {
            assert (x.getTagCompound() != null);
            return x.getTagCompound().equals((Object)center.getTagCompound());
        })) {
            return false;
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(this.outsideIngredients);
        while (test.size() > ingredients.size()) {
            ingredients.add(Ingredient.EMPTY);
        }
        for (ItemStack stack : test) {
            Optional<Ingredient> found = ingredients.stream().filter(x -> x.apply(stack)).findFirst();
            if (found.isPresent()) {
                if (stack.getTagCompound() != null && Arrays.stream(found.get().getMatchingStacks()).noneMatch(x -> {
                    assert (x.getTagCompound() != null);
                    return x.getTagCompound().equals((Object)stack.getTagCompound());
                })) {
                    return false;
                }
                ingredients.remove(found.get());
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isFailure(AlchemyResult result) {
        return result.getAccuracy() != 1.0;
    }

    public ItemStack getResult(TileEntity tile) {
        return this.result.copy();
    }

    public final ItemStack getResult(TileEntity tile, AspectList aspects) {
        World world = tile.getWorld();
        return this.getResultInternal(world, tile, aspects);
    }

    @Deprecated
    public final ItemStack getResult(World world, int iron, int dawnstone, int copper, int silver, int lead) {
        AspectList inputAspects = AspectList.createStandard(iron, dawnstone, copper, silver, lead);
        return this.getResultInternal(world, null, inputAspects);
    }

    private ItemStack getResultInternal(World world, TileEntity tile, AspectList inputAspects) {
        AlchemyResult result = this.matchAshes(inputAspects, world);
        if (this.isFailure(result)) {
            return this.getResult(tile);
        }
        return result.createFailure();
    }

    public final ItemStack getOutput() {
        return this.result;
    }

    public final Ingredient getCenter() {
        return this.centerIngredient;
    }
}

