/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.power;

import net.minecraft.nbt.NBTTagCompound;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.config.ConfigMachine;

public class DefaultEmberCapability
implements IEmberCapability {
    public static boolean allAcceptVolatile = ConfigMachine.EMBER_CONDUIT.all_accept_volatile;
    private double ember = 0.0;
    private double capacity = 0.0;

    @Override
    public double getEmber() {
        return this.ember;
    }

    @Override
    public double getEmberCapacity() {
        return this.capacity;
    }

    @Override
    public void setEmber(double value) {
        this.ember = value;
    }

    @Override
    public void setEmberCapacity(double value) {
        this.capacity = value;
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        double added = Math.min(this.capacity - this.ember, value);
        double newEmber = this.ember + added;
        if (doAdd) {
            if (newEmber != this.ember) {
                this.onContentsChanged();
            }
            this.ember += added;
        }
        return added;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        double removed = Math.min(this.ember, value);
        double newEmber = this.ember - removed;
        if (doRemove) {
            if (newEmber != this.ember) {
                this.onContentsChanged();
            }
            this.ember -= removed;
        }
        return removed;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setDouble("embers:ember", this.ember);
        tag.setDouble("embers:emberCapacity", this.capacity);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("embers:ember")) {
            this.ember = tag.getDouble("embers:ember");
        }
        if (tag.hasKey("embers:emberCapacity")) {
            this.capacity = tag.getDouble("embers:emberCapacity");
        }
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    public boolean acceptsVolatile() {
        return allAcceptVolatile;
    }
}

